/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.rds.model.StartDbInstanceRequest;

public class StartDbInstanceRequestMarshaller
implements Marshaller<Request<StartDbInstanceRequest>, StartDbInstanceRequest> {
    public Request<StartDbInstanceRequest> marshall(StartDbInstanceRequest startDbInstanceRequest) {
        if (startDbInstanceRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)startDbInstanceRequest, "RdsClient");
        request.addParameter("Action", "StartDBInstance");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (startDbInstanceRequest.dbInstanceIdentifier() != null) {
            request.addParameter("DBInstanceIdentifier", StringConversion.fromString((String)startDbInstanceRequest.dbInstanceIdentifier()));
        }
        return request;
    }
}

