/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.rds.model.CloudwatchLogsExportConfiguration;
import software.amazon.awssdk.services.rds.model.ModifyDbClusterRequest;
import software.amazon.awssdk.services.rds.model.ScalingConfiguration;

public class ModifyDbClusterRequestMarshaller
implements Marshaller<Request<ModifyDbClusterRequest>, ModifyDbClusterRequest> {
    public Request<ModifyDbClusterRequest> marshall(ModifyDbClusterRequest modifyDbClusterRequest) {
        ScalingConfiguration scalingConfiguration;
        CloudwatchLogsExportConfiguration cloudwatchLogsExportConfiguration;
        if (modifyDbClusterRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)modifyDbClusterRequest, "RdsClient");
        request.addParameter("Action", "ModifyDBCluster");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyDbClusterRequest.dbClusterIdentifier() != null) {
            request.addParameter("DBClusterIdentifier", StringConversion.fromString((String)modifyDbClusterRequest.dbClusterIdentifier()));
        }
        if (modifyDbClusterRequest.newDBClusterIdentifier() != null) {
            request.addParameter("NewDBClusterIdentifier", StringConversion.fromString((String)modifyDbClusterRequest.newDBClusterIdentifier()));
        }
        if (modifyDbClusterRequest.applyImmediately() != null) {
            request.addParameter("ApplyImmediately", StringConversion.fromBoolean((Boolean)modifyDbClusterRequest.applyImmediately()));
        }
        if (modifyDbClusterRequest.backupRetentionPeriod() != null) {
            request.addParameter("BackupRetentionPeriod", StringConversion.fromInteger((Integer)modifyDbClusterRequest.backupRetentionPeriod()));
        }
        if (modifyDbClusterRequest.dbClusterParameterGroupName() != null) {
            request.addParameter("DBClusterParameterGroupName", StringConversion.fromString((String)modifyDbClusterRequest.dbClusterParameterGroupName()));
        }
        if (modifyDbClusterRequest.vpcSecurityGroupIds().isEmpty() && !(modifyDbClusterRequest.vpcSecurityGroupIds() instanceof SdkAutoConstructList)) {
            request.addParameter("VpcSecurityGroupIds", "");
        } else if (!modifyDbClusterRequest.vpcSecurityGroupIds().isEmpty() && !(modifyDbClusterRequest.vpcSecurityGroupIds() instanceof SdkAutoConstructList)) {
            List<String> vpcSecurityGroupIdsList = modifyDbClusterRequest.vpcSecurityGroupIds();
            int vpcSecurityGroupIdsListIndex = 1;
            for (String vpcSecurityGroupIdsListValue : vpcSecurityGroupIdsList) {
                if (vpcSecurityGroupIdsListValue != null) {
                    request.addParameter("VpcSecurityGroupIds.VpcSecurityGroupId." + vpcSecurityGroupIdsListIndex, StringConversion.fromString((String)vpcSecurityGroupIdsListValue));
                }
                ++vpcSecurityGroupIdsListIndex;
            }
        }
        if (modifyDbClusterRequest.port() != null) {
            request.addParameter("Port", StringConversion.fromInteger((Integer)modifyDbClusterRequest.port()));
        }
        if (modifyDbClusterRequest.masterUserPassword() != null) {
            request.addParameter("MasterUserPassword", StringConversion.fromString((String)modifyDbClusterRequest.masterUserPassword()));
        }
        if (modifyDbClusterRequest.optionGroupName() != null) {
            request.addParameter("OptionGroupName", StringConversion.fromString((String)modifyDbClusterRequest.optionGroupName()));
        }
        if (modifyDbClusterRequest.preferredBackupWindow() != null) {
            request.addParameter("PreferredBackupWindow", StringConversion.fromString((String)modifyDbClusterRequest.preferredBackupWindow()));
        }
        if (modifyDbClusterRequest.preferredMaintenanceWindow() != null) {
            request.addParameter("PreferredMaintenanceWindow", StringConversion.fromString((String)modifyDbClusterRequest.preferredMaintenanceWindow()));
        }
        if (modifyDbClusterRequest.enableIAMDatabaseAuthentication() != null) {
            request.addParameter("EnableIAMDatabaseAuthentication", StringConversion.fromBoolean((Boolean)modifyDbClusterRequest.enableIAMDatabaseAuthentication()));
        }
        if (modifyDbClusterRequest.backtrackWindow() != null) {
            request.addParameter("BacktrackWindow", StringConversion.fromLong((Long)modifyDbClusterRequest.backtrackWindow()));
        }
        if ((cloudwatchLogsExportConfiguration = modifyDbClusterRequest.cloudwatchLogsExportConfiguration()) != null) {
            if (cloudwatchLogsExportConfiguration.enableLogTypes().isEmpty() && !(cloudwatchLogsExportConfiguration.enableLogTypes() instanceof SdkAutoConstructList)) {
                request.addParameter("CloudwatchLogsExportConfiguration.EnableLogTypes", "");
            } else if (!cloudwatchLogsExportConfiguration.enableLogTypes().isEmpty() && !(cloudwatchLogsExportConfiguration.enableLogTypes() instanceof SdkAutoConstructList)) {
                List<String> enableLogTypesList = cloudwatchLogsExportConfiguration.enableLogTypes();
                int enableLogTypesListIndex = 1;
                for (String enableLogTypesListValue : enableLogTypesList) {
                    if (enableLogTypesListValue != null) {
                        request.addParameter("CloudwatchLogsExportConfiguration.EnableLogTypes.member." + enableLogTypesListIndex, StringConversion.fromString((String)enableLogTypesListValue));
                    }
                    ++enableLogTypesListIndex;
                }
            }
            if (cloudwatchLogsExportConfiguration.disableLogTypes().isEmpty() && !(cloudwatchLogsExportConfiguration.disableLogTypes() instanceof SdkAutoConstructList)) {
                request.addParameter("CloudwatchLogsExportConfiguration.DisableLogTypes", "");
            } else if (!cloudwatchLogsExportConfiguration.disableLogTypes().isEmpty() && !(cloudwatchLogsExportConfiguration.disableLogTypes() instanceof SdkAutoConstructList)) {
                List<String> disableLogTypesList = cloudwatchLogsExportConfiguration.disableLogTypes();
                int disableLogTypesListIndex = 1;
                for (String disableLogTypesListValue : disableLogTypesList) {
                    if (disableLogTypesListValue != null) {
                        request.addParameter("CloudwatchLogsExportConfiguration.DisableLogTypes.member." + disableLogTypesListIndex, StringConversion.fromString((String)disableLogTypesListValue));
                    }
                    ++disableLogTypesListIndex;
                }
            }
        }
        if (modifyDbClusterRequest.engineVersion() != null) {
            request.addParameter("EngineVersion", StringConversion.fromString((String)modifyDbClusterRequest.engineVersion()));
        }
        if ((scalingConfiguration = modifyDbClusterRequest.scalingConfiguration()) != null) {
            if (scalingConfiguration.minCapacity() != null) {
                request.addParameter("ScalingConfiguration.MinCapacity", StringConversion.fromInteger((Integer)scalingConfiguration.minCapacity()));
            }
            if (scalingConfiguration.maxCapacity() != null) {
                request.addParameter("ScalingConfiguration.MaxCapacity", StringConversion.fromInteger((Integer)scalingConfiguration.maxCapacity()));
            }
            if (scalingConfiguration.autoPause() != null) {
                request.addParameter("ScalingConfiguration.AutoPause", StringConversion.fromBoolean((Boolean)scalingConfiguration.autoPause()));
            }
            if (scalingConfiguration.secondsUntilAutoPause() != null) {
                request.addParameter("ScalingConfiguration.SecondsUntilAutoPause", StringConversion.fromInteger((Integer)scalingConfiguration.secondsUntilAutoPause()));
            }
        }
        return request;
    }
}

