/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.rds.model.FailoverDbClusterRequest;

public class FailoverDbClusterRequestMarshaller
implements Marshaller<Request<FailoverDbClusterRequest>, FailoverDbClusterRequest> {
    public Request<FailoverDbClusterRequest> marshall(FailoverDbClusterRequest failoverDbClusterRequest) {
        if (failoverDbClusterRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)failoverDbClusterRequest, "RdsClient");
        request.addParameter("Action", "FailoverDBCluster");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (failoverDbClusterRequest.dbClusterIdentifier() != null) {
            request.addParameter("DBClusterIdentifier", StringConversion.fromString((String)failoverDbClusterRequest.dbClusterIdentifier()));
        }
        if (failoverDbClusterRequest.targetDBInstanceIdentifier() != null) {
            request.addParameter("TargetDBInstanceIdentifier", StringConversion.fromString((String)failoverDbClusterRequest.targetDBInstanceIdentifier()));
        }
        return request;
    }
}

