/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.rds.model.DeleteDbSnapshotRequest;

public class DeleteDbSnapshotRequestMarshaller
implements Marshaller<Request<DeleteDbSnapshotRequest>, DeleteDbSnapshotRequest> {
    public Request<DeleteDbSnapshotRequest> marshall(DeleteDbSnapshotRequest deleteDbSnapshotRequest) {
        if (deleteDbSnapshotRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)deleteDbSnapshotRequest, "RdsClient");
        request.addParameter("Action", "DeleteDBSnapshot");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteDbSnapshotRequest.dbSnapshotIdentifier() != null) {
            request.addParameter("DBSnapshotIdentifier", StringConversion.fromString((String)deleteDbSnapshotRequest.dbSnapshotIdentifier()));
        }
        return request;
    }
}

