/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.rds.model.DBClusterBacktrack;

public class DBClusterBacktrackUnmarshaller
implements Unmarshaller<DBClusterBacktrack, StaxUnmarshallerContext> {
    private static final DBClusterBacktrackUnmarshaller INSTANCE = new DBClusterBacktrackUnmarshaller();

    public DBClusterBacktrack unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        DBClusterBacktrack.Builder dbClusterBacktrack = DBClusterBacktrack.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("DBClusterIdentifier", targetDepth)) {
                    dbClusterBacktrack.dbClusterIdentifier(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("BacktrackIdentifier", targetDepth)) {
                    dbClusterBacktrack.backtrackIdentifier(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("BacktrackTo", targetDepth)) {
                    dbClusterBacktrack.backtrackTo(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("BacktrackedFrom", targetDepth)) {
                    dbClusterBacktrack.backtrackedFrom(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("BacktrackRequestCreationTime", targetDepth)) {
                    dbClusterBacktrack.backtrackRequestCreationTime(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Status", targetDepth)) continue;
                dbClusterBacktrack.status(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (DBClusterBacktrack)dbClusterBacktrack.build();
    }

    public static DBClusterBacktrackUnmarshaller getInstance() {
        return INSTANCE;
    }
}

