/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.time.Instant;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.rds.model.BacktrackDbClusterRequest;

public class BacktrackDbClusterRequestMarshaller
implements Marshaller<Request<BacktrackDbClusterRequest>, BacktrackDbClusterRequest> {
    public Request<BacktrackDbClusterRequest> marshall(BacktrackDbClusterRequest backtrackDbClusterRequest) {
        if (backtrackDbClusterRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)backtrackDbClusterRequest, "RdsClient");
        request.addParameter("Action", "BacktrackDBCluster");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (backtrackDbClusterRequest.dbClusterIdentifier() != null) {
            request.addParameter("DBClusterIdentifier", StringConversion.fromString((String)backtrackDbClusterRequest.dbClusterIdentifier()));
        }
        if (backtrackDbClusterRequest.backtrackTo() != null) {
            request.addParameter("BacktrackTo", StringConversion.fromInstant((Instant)backtrackDbClusterRequest.backtrackTo()));
        }
        if (backtrackDbClusterRequest.force() != null) {
            request.addParameter("Force", StringConversion.fromBoolean((Boolean)backtrackDbClusterRequest.force()));
        }
        if (backtrackDbClusterRequest.useEarliestTimeOnPointInTimeUnavailable() != null) {
            request.addParameter("UseEarliestTimeOnPointInTimeUnavailable", StringConversion.fromBoolean((Boolean)backtrackDbClusterRequest.useEarliestTimeOnPointInTimeUnavailable()));
        }
        return request;
    }
}

