/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.rds.model.RdsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyCurrentDbClusterCapacityResponse
extends RdsResponse
implements ToCopyableBuilder<Builder, ModifyCurrentDbClusterCapacityResponse> {
    private final String dbClusterIdentifier;
    private final Integer pendingCapacity;
    private final Integer currentCapacity;
    private final Integer secondsBeforeTimeout;
    private final String timeoutAction;

    private ModifyCurrentDbClusterCapacityResponse(BuilderImpl builder) {
        super(builder);
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.pendingCapacity = builder.pendingCapacity;
        this.currentCapacity = builder.currentCapacity;
        this.secondsBeforeTimeout = builder.secondsBeforeTimeout;
        this.timeoutAction = builder.timeoutAction;
    }

    public String dbClusterIdentifier() {
        return this.dbClusterIdentifier;
    }

    public Integer pendingCapacity() {
        return this.pendingCapacity;
    }

    public Integer currentCapacity() {
        return this.currentCapacity;
    }

    public Integer secondsBeforeTimeout() {
        return this.secondsBeforeTimeout;
    }

    public String timeoutAction() {
        return this.timeoutAction;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.pendingCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.secondsBeforeTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutAction());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyCurrentDbClusterCapacityResponse)) {
            return false;
        }
        ModifyCurrentDbClusterCapacityResponse other = (ModifyCurrentDbClusterCapacityResponse)((Object)obj);
        return Objects.equals(this.dbClusterIdentifier(), other.dbClusterIdentifier()) && Objects.equals(this.pendingCapacity(), other.pendingCapacity()) && Objects.equals(this.currentCapacity(), other.currentCapacity()) && Objects.equals(this.secondsBeforeTimeout(), other.secondsBeforeTimeout()) && Objects.equals(this.timeoutAction(), other.timeoutAction());
    }

    public String toString() {
        return ToString.builder((String)"ModifyCurrentDbClusterCapacityResponse").add("DBClusterIdentifier", (Object)this.dbClusterIdentifier()).add("PendingCapacity", (Object)this.pendingCapacity()).add("CurrentCapacity", (Object)this.currentCapacity()).add("SecondsBeforeTimeout", (Object)this.secondsBeforeTimeout()).add("TimeoutAction", (Object)this.timeoutAction()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbClusterIdentifier()));
            }
            case "PendingCapacity": {
                return Optional.ofNullable(clazz.cast(this.pendingCapacity()));
            }
            case "CurrentCapacity": {
                return Optional.ofNullable(clazz.cast(this.currentCapacity()));
            }
            case "SecondsBeforeTimeout": {
                return Optional.ofNullable(clazz.cast(this.secondsBeforeTimeout()));
            }
            case "TimeoutAction": {
                return Optional.ofNullable(clazz.cast(this.timeoutAction()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RdsResponse.BuilderImpl
    implements Builder {
        private String dbClusterIdentifier;
        private Integer pendingCapacity;
        private Integer currentCapacity;
        private Integer secondsBeforeTimeout;
        private String timeoutAction;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyCurrentDbClusterCapacityResponse model) {
            super(model);
            this.dbClusterIdentifier(model.dbClusterIdentifier);
            this.pendingCapacity(model.pendingCapacity);
            this.currentCapacity(model.currentCapacity);
            this.secondsBeforeTimeout(model.secondsBeforeTimeout);
            this.timeoutAction(model.timeoutAction);
        }

        public final String getDBClusterIdentifier() {
            return this.dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final void setDBClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        public final Integer getPendingCapacity() {
            return this.pendingCapacity;
        }

        @Override
        public final Builder pendingCapacity(Integer pendingCapacity) {
            this.pendingCapacity = pendingCapacity;
            return this;
        }

        public final void setPendingCapacity(Integer pendingCapacity) {
            this.pendingCapacity = pendingCapacity;
        }

        public final Integer getCurrentCapacity() {
            return this.currentCapacity;
        }

        @Override
        public final Builder currentCapacity(Integer currentCapacity) {
            this.currentCapacity = currentCapacity;
            return this;
        }

        public final void setCurrentCapacity(Integer currentCapacity) {
            this.currentCapacity = currentCapacity;
        }

        public final Integer getSecondsBeforeTimeout() {
            return this.secondsBeforeTimeout;
        }

        @Override
        public final Builder secondsBeforeTimeout(Integer secondsBeforeTimeout) {
            this.secondsBeforeTimeout = secondsBeforeTimeout;
            return this;
        }

        public final void setSecondsBeforeTimeout(Integer secondsBeforeTimeout) {
            this.secondsBeforeTimeout = secondsBeforeTimeout;
        }

        public final String getTimeoutAction() {
            return this.timeoutAction;
        }

        @Override
        public final Builder timeoutAction(String timeoutAction) {
            this.timeoutAction = timeoutAction;
            return this;
        }

        public final void setTimeoutAction(String timeoutAction) {
            this.timeoutAction = timeoutAction;
        }

        @Override
        public ModifyCurrentDbClusterCapacityResponse build() {
            return new ModifyCurrentDbClusterCapacityResponse(this);
        }
    }

    public static interface Builder
    extends RdsResponse.Builder,
    CopyableBuilder<Builder, ModifyCurrentDbClusterCapacityResponse> {
        public Builder dbClusterIdentifier(String var1);

        public Builder pendingCapacity(Integer var1);

        public Builder currentCapacity(Integer var1);

        public Builder secondsBeforeTimeout(Integer var1);

        public Builder timeoutAction(String var1);
    }
}

