/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CharacterSet
implements ToCopyableBuilder<Builder, CharacterSet> {
    private final String characterSetName;
    private final String characterSetDescription;

    private CharacterSet(BuilderImpl builder) {
        this.characterSetName = builder.characterSetName;
        this.characterSetDescription = builder.characterSetDescription;
    }

    public String characterSetName() {
        return this.characterSetName;
    }

    public String characterSetDescription() {
        return this.characterSetDescription;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.characterSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.characterSetDescription());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CharacterSet)) {
            return false;
        }
        CharacterSet other = (CharacterSet)obj;
        return Objects.equals(this.characterSetName(), other.characterSetName()) && Objects.equals(this.characterSetDescription(), other.characterSetDescription());
    }

    public String toString() {
        return ToString.builder((String)"CharacterSet").add("CharacterSetName", (Object)this.characterSetName()).add("CharacterSetDescription", (Object)this.characterSetDescription()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CharacterSetName": {
                return Optional.ofNullable(clazz.cast(this.characterSetName()));
            }
            case "CharacterSetDescription": {
                return Optional.ofNullable(clazz.cast(this.characterSetDescription()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String characterSetName;
        private String characterSetDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(CharacterSet model) {
            this.characterSetName(model.characterSetName);
            this.characterSetDescription(model.characterSetDescription);
        }

        public final String getCharacterSetName() {
            return this.characterSetName;
        }

        @Override
        public final Builder characterSetName(String characterSetName) {
            this.characterSetName = characterSetName;
            return this;
        }

        public final void setCharacterSetName(String characterSetName) {
            this.characterSetName = characterSetName;
        }

        public final String getCharacterSetDescription() {
            return this.characterSetDescription;
        }

        @Override
        public final Builder characterSetDescription(String characterSetDescription) {
            this.characterSetDescription = characterSetDescription;
            return this;
        }

        public final void setCharacterSetDescription(String characterSetDescription) {
            this.characterSetDescription = characterSetDescription;
        }

        public CharacterSet build() {
            return new CharacterSet(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CharacterSet> {
        public Builder characterSetName(String var1);

        public Builder characterSetDescription(String var1);
    }
}

