/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BacktrackDbClusterRequest
extends RdsRequest
implements ToCopyableBuilder<Builder, BacktrackDbClusterRequest> {
    private final String dbClusterIdentifier;
    private final Instant backtrackTo;
    private final Boolean force;
    private final Boolean useEarliestTimeOnPointInTimeUnavailable;

    private BacktrackDbClusterRequest(BuilderImpl builder) {
        super(builder);
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.backtrackTo = builder.backtrackTo;
        this.force = builder.force;
        this.useEarliestTimeOnPointInTimeUnavailable = builder.useEarliestTimeOnPointInTimeUnavailable;
    }

    public String dbClusterIdentifier() {
        return this.dbClusterIdentifier;
    }

    public Instant backtrackTo() {
        return this.backtrackTo;
    }

    public Boolean force() {
        return this.force;
    }

    public Boolean useEarliestTimeOnPointInTimeUnavailable() {
        return this.useEarliestTimeOnPointInTimeUnavailable;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.backtrackTo());
        hashCode = 31 * hashCode + Objects.hashCode(this.force());
        hashCode = 31 * hashCode + Objects.hashCode(this.useEarliestTimeOnPointInTimeUnavailable());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BacktrackDbClusterRequest)) {
            return false;
        }
        BacktrackDbClusterRequest other = (BacktrackDbClusterRequest)((Object)obj);
        return Objects.equals(this.dbClusterIdentifier(), other.dbClusterIdentifier()) && Objects.equals(this.backtrackTo(), other.backtrackTo()) && Objects.equals(this.force(), other.force()) && Objects.equals(this.useEarliestTimeOnPointInTimeUnavailable(), other.useEarliestTimeOnPointInTimeUnavailable());
    }

    public String toString() {
        return ToString.builder((String)"BacktrackDbClusterRequest").add("DBClusterIdentifier", (Object)this.dbClusterIdentifier()).add("BacktrackTo", (Object)this.backtrackTo()).add("Force", (Object)this.force()).add("UseEarliestTimeOnPointInTimeUnavailable", (Object)this.useEarliestTimeOnPointInTimeUnavailable()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbClusterIdentifier()));
            }
            case "BacktrackTo": {
                return Optional.ofNullable(clazz.cast(this.backtrackTo()));
            }
            case "Force": {
                return Optional.ofNullable(clazz.cast(this.force()));
            }
            case "UseEarliestTimeOnPointInTimeUnavailable": {
                return Optional.ofNullable(clazz.cast(this.useEarliestTimeOnPointInTimeUnavailable()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private String dbClusterIdentifier;
        private Instant backtrackTo;
        private Boolean force;
        private Boolean useEarliestTimeOnPointInTimeUnavailable;

        private BuilderImpl() {
        }

        private BuilderImpl(BacktrackDbClusterRequest model) {
            super(model);
            this.dbClusterIdentifier(model.dbClusterIdentifier);
            this.backtrackTo(model.backtrackTo);
            this.force(model.force);
            this.useEarliestTimeOnPointInTimeUnavailable(model.useEarliestTimeOnPointInTimeUnavailable);
        }

        public final String getDBClusterIdentifier() {
            return this.dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final void setDBClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        public final Instant getBacktrackTo() {
            return this.backtrackTo;
        }

        @Override
        public final Builder backtrackTo(Instant backtrackTo) {
            this.backtrackTo = backtrackTo;
            return this;
        }

        public final void setBacktrackTo(Instant backtrackTo) {
            this.backtrackTo = backtrackTo;
        }

        public final Boolean getForce() {
            return this.force;
        }

        @Override
        public final Builder force(Boolean force) {
            this.force = force;
            return this;
        }

        public final void setForce(Boolean force) {
            this.force = force;
        }

        public final Boolean getUseEarliestTimeOnPointInTimeUnavailable() {
            return this.useEarliestTimeOnPointInTimeUnavailable;
        }

        @Override
        public final Builder useEarliestTimeOnPointInTimeUnavailable(Boolean useEarliestTimeOnPointInTimeUnavailable) {
            this.useEarliestTimeOnPointInTimeUnavailable = useEarliestTimeOnPointInTimeUnavailable;
            return this;
        }

        public final void setUseEarliestTimeOnPointInTimeUnavailable(Boolean useEarliestTimeOnPointInTimeUnavailable) {
            this.useEarliestTimeOnPointInTimeUnavailable = useEarliestTimeOnPointInTimeUnavailable;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BacktrackDbClusterRequest build() {
            return new BacktrackDbClusterRequest(this);
        }
    }

    public static interface Builder
    extends RdsRequest.Builder,
    CopyableBuilder<Builder, BacktrackDbClusterRequest> {
        public Builder dbClusterIdentifier(String var1);

        public Builder backtrackTo(Instant var1);

        public Builder force(Boolean var1);

        public Builder useEarliestTimeOnPointInTimeUnavailable(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

