/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.rds.model.ModifyDbInstanceRequest;

public class ModifyDbInstanceRequestMarshaller
implements Marshaller<Request<ModifyDbInstanceRequest>, ModifyDbInstanceRequest> {
    public Request<ModifyDbInstanceRequest> marshall(ModifyDbInstanceRequest modifyDbInstanceRequest) {
        if (modifyDbInstanceRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)modifyDbInstanceRequest, "RdsClient");
        request.addParameter("Action", "ModifyDBInstance");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyDbInstanceRequest.dbInstanceIdentifier() != null) {
            request.addParameter("DBInstanceIdentifier", StringConversion.fromString((String)modifyDbInstanceRequest.dbInstanceIdentifier()));
        }
        if (modifyDbInstanceRequest.allocatedStorage() != null) {
            request.addParameter("AllocatedStorage", StringConversion.fromInteger((Integer)modifyDbInstanceRequest.allocatedStorage()));
        }
        if (modifyDbInstanceRequest.dbInstanceClass() != null) {
            request.addParameter("DBInstanceClass", StringConversion.fromString((String)modifyDbInstanceRequest.dbInstanceClass()));
        }
        if (modifyDbInstanceRequest.dbSubnetGroupName() != null) {
            request.addParameter("DBSubnetGroupName", StringConversion.fromString((String)modifyDbInstanceRequest.dbSubnetGroupName()));
        }
        if (modifyDbInstanceRequest.dbSecurityGroups().isEmpty() && !(modifyDbInstanceRequest.dbSecurityGroups() instanceof SdkAutoConstructList)) {
            request.addParameter("DBSecurityGroups", "");
        } else if (!modifyDbInstanceRequest.dbSecurityGroups().isEmpty() && !(modifyDbInstanceRequest.dbSecurityGroups() instanceof SdkAutoConstructList)) {
            List<String> dBSecurityGroupsList = modifyDbInstanceRequest.dbSecurityGroups();
            int dBSecurityGroupsListIndex = 1;
            for (String dBSecurityGroupsListValue : dBSecurityGroupsList) {
                if (dBSecurityGroupsListValue != null) {
                    request.addParameter("DBSecurityGroups.DBSecurityGroupName." + dBSecurityGroupsListIndex, StringConversion.fromString((String)dBSecurityGroupsListValue));
                }
                ++dBSecurityGroupsListIndex;
            }
        }
        if (modifyDbInstanceRequest.vpcSecurityGroupIds().isEmpty() && !(modifyDbInstanceRequest.vpcSecurityGroupIds() instanceof SdkAutoConstructList)) {
            request.addParameter("VpcSecurityGroupIds", "");
        } else if (!modifyDbInstanceRequest.vpcSecurityGroupIds().isEmpty() && !(modifyDbInstanceRequest.vpcSecurityGroupIds() instanceof SdkAutoConstructList)) {
            List<String> vpcSecurityGroupIdsList = modifyDbInstanceRequest.vpcSecurityGroupIds();
            int vpcSecurityGroupIdsListIndex = 1;
            for (String vpcSecurityGroupIdsListValue : vpcSecurityGroupIdsList) {
                if (vpcSecurityGroupIdsListValue != null) {
                    request.addParameter("VpcSecurityGroupIds.VpcSecurityGroupId." + vpcSecurityGroupIdsListIndex, StringConversion.fromString((String)vpcSecurityGroupIdsListValue));
                }
                ++vpcSecurityGroupIdsListIndex;
            }
        }
        if (modifyDbInstanceRequest.applyImmediately() != null) {
            request.addParameter("ApplyImmediately", StringConversion.fromBoolean((Boolean)modifyDbInstanceRequest.applyImmediately()));
        }
        if (modifyDbInstanceRequest.masterUserPassword() != null) {
            request.addParameter("MasterUserPassword", StringConversion.fromString((String)modifyDbInstanceRequest.masterUserPassword()));
        }
        if (modifyDbInstanceRequest.dbParameterGroupName() != null) {
            request.addParameter("DBParameterGroupName", StringConversion.fromString((String)modifyDbInstanceRequest.dbParameterGroupName()));
        }
        if (modifyDbInstanceRequest.backupRetentionPeriod() != null) {
            request.addParameter("BackupRetentionPeriod", StringConversion.fromInteger((Integer)modifyDbInstanceRequest.backupRetentionPeriod()));
        }
        if (modifyDbInstanceRequest.preferredBackupWindow() != null) {
            request.addParameter("PreferredBackupWindow", StringConversion.fromString((String)modifyDbInstanceRequest.preferredBackupWindow()));
        }
        if (modifyDbInstanceRequest.preferredMaintenanceWindow() != null) {
            request.addParameter("PreferredMaintenanceWindow", StringConversion.fromString((String)modifyDbInstanceRequest.preferredMaintenanceWindow()));
        }
        if (modifyDbInstanceRequest.multiAZ() != null) {
            request.addParameter("MultiAZ", StringConversion.fromBoolean((Boolean)modifyDbInstanceRequest.multiAZ()));
        }
        if (modifyDbInstanceRequest.engineVersion() != null) {
            request.addParameter("EngineVersion", StringConversion.fromString((String)modifyDbInstanceRequest.engineVersion()));
        }
        if (modifyDbInstanceRequest.allowMajorVersionUpgrade() != null) {
            request.addParameter("AllowMajorVersionUpgrade", StringConversion.fromBoolean((Boolean)modifyDbInstanceRequest.allowMajorVersionUpgrade()));
        }
        if (modifyDbInstanceRequest.autoMinorVersionUpgrade() != null) {
            request.addParameter("AutoMinorVersionUpgrade", StringConversion.fromBoolean((Boolean)modifyDbInstanceRequest.autoMinorVersionUpgrade()));
        }
        if (modifyDbInstanceRequest.licenseModel() != null) {
            request.addParameter("LicenseModel", StringConversion.fromString((String)modifyDbInstanceRequest.licenseModel()));
        }
        if (modifyDbInstanceRequest.iops() != null) {
            request.addParameter("Iops", StringConversion.fromInteger((Integer)modifyDbInstanceRequest.iops()));
        }
        if (modifyDbInstanceRequest.optionGroupName() != null) {
            request.addParameter("OptionGroupName", StringConversion.fromString((String)modifyDbInstanceRequest.optionGroupName()));
        }
        if (modifyDbInstanceRequest.newDBInstanceIdentifier() != null) {
            request.addParameter("NewDBInstanceIdentifier", StringConversion.fromString((String)modifyDbInstanceRequest.newDBInstanceIdentifier()));
        }
        if (modifyDbInstanceRequest.storageType() != null) {
            request.addParameter("StorageType", StringConversion.fromString((String)modifyDbInstanceRequest.storageType()));
        }
        if (modifyDbInstanceRequest.tdeCredentialArn() != null) {
            request.addParameter("TdeCredentialArn", StringConversion.fromString((String)modifyDbInstanceRequest.tdeCredentialArn()));
        }
        if (modifyDbInstanceRequest.tdeCredentialPassword() != null) {
            request.addParameter("TdeCredentialPassword", StringConversion.fromString((String)modifyDbInstanceRequest.tdeCredentialPassword()));
        }
        if (modifyDbInstanceRequest.caCertificateIdentifier() != null) {
            request.addParameter("CACertificateIdentifier", StringConversion.fromString((String)modifyDbInstanceRequest.caCertificateIdentifier()));
        }
        if (modifyDbInstanceRequest.domain() != null) {
            request.addParameter("Domain", StringConversion.fromString((String)modifyDbInstanceRequest.domain()));
        }
        if (modifyDbInstanceRequest.copyTagsToSnapshot() != null) {
            request.addParameter("CopyTagsToSnapshot", StringConversion.fromBoolean((Boolean)modifyDbInstanceRequest.copyTagsToSnapshot()));
        }
        if (modifyDbInstanceRequest.monitoringInterval() != null) {
            request.addParameter("MonitoringInterval", StringConversion.fromInteger((Integer)modifyDbInstanceRequest.monitoringInterval()));
        }
        if (modifyDbInstanceRequest.dbPortNumber() != null) {
            request.addParameter("DBPortNumber", StringConversion.fromInteger((Integer)modifyDbInstanceRequest.dbPortNumber()));
        }
        if (modifyDbInstanceRequest.publiclyAccessible() != null) {
            request.addParameter("PubliclyAccessible", StringConversion.fromBoolean((Boolean)modifyDbInstanceRequest.publiclyAccessible()));
        }
        if (modifyDbInstanceRequest.monitoringRoleArn() != null) {
            request.addParameter("MonitoringRoleArn", StringConversion.fromString((String)modifyDbInstanceRequest.monitoringRoleArn()));
        }
        if (modifyDbInstanceRequest.domainIAMRoleName() != null) {
            request.addParameter("DomainIAMRoleName", StringConversion.fromString((String)modifyDbInstanceRequest.domainIAMRoleName()));
        }
        if (modifyDbInstanceRequest.promotionTier() != null) {
            request.addParameter("PromotionTier", StringConversion.fromInteger((Integer)modifyDbInstanceRequest.promotionTier()));
        }
        if (modifyDbInstanceRequest.enableIAMDatabaseAuthentication() != null) {
            request.addParameter("EnableIAMDatabaseAuthentication", StringConversion.fromBoolean((Boolean)modifyDbInstanceRequest.enableIAMDatabaseAuthentication()));
        }
        if (modifyDbInstanceRequest.enablePerformanceInsights() != null) {
            request.addParameter("EnablePerformanceInsights", StringConversion.fromBoolean((Boolean)modifyDbInstanceRequest.enablePerformanceInsights()));
        }
        if (modifyDbInstanceRequest.performanceInsightsKMSKeyId() != null) {
            request.addParameter("PerformanceInsightsKMSKeyId", StringConversion.fromString((String)modifyDbInstanceRequest.performanceInsightsKMSKeyId()));
        }
        return request;
    }
}

