/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.rds.model.DescribeDbEngineVersionsRequest;
import software.amazon.awssdk.services.rds.model.Filter;

public class DescribeDbEngineVersionsRequestMarshaller
implements Marshaller<Request<DescribeDbEngineVersionsRequest>, DescribeDbEngineVersionsRequest> {
    public Request<DescribeDbEngineVersionsRequest> marshall(DescribeDbEngineVersionsRequest describeDbEngineVersionsRequest) {
        if (describeDbEngineVersionsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeDbEngineVersionsRequest, "RdsClient");
        request.addParameter("Action", "DescribeDBEngineVersions");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeDbEngineVersionsRequest.engine() != null) {
            request.addParameter("Engine", StringConversion.fromString((String)describeDbEngineVersionsRequest.engine()));
        }
        if (describeDbEngineVersionsRequest.engineVersion() != null) {
            request.addParameter("EngineVersion", StringConversion.fromString((String)describeDbEngineVersionsRequest.engineVersion()));
        }
        if (describeDbEngineVersionsRequest.dbParameterGroupFamily() != null) {
            request.addParameter("DBParameterGroupFamily", StringConversion.fromString((String)describeDbEngineVersionsRequest.dbParameterGroupFamily()));
        }
        if (describeDbEngineVersionsRequest.filters().isEmpty() && !(describeDbEngineVersionsRequest.filters() instanceof SdkAutoConstructList)) {
            request.addParameter("Filters", "");
        } else if (!describeDbEngineVersionsRequest.filters().isEmpty() && !(describeDbEngineVersionsRequest.filters() instanceof SdkAutoConstructList)) {
            List<Filter> filtersList = describeDbEngineVersionsRequest.filters();
            int filtersListIndex = 1;
            for (Filter filtersListValue : filtersList) {
                if (filtersListValue.name() != null) {
                    request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringConversion.fromString((String)filtersListValue.name()));
                }
                if (filtersListValue.values().isEmpty() && !(filtersListValue.values() instanceof SdkAutoConstructList)) {
                    request.addParameter("Filters.Filter." + filtersListIndex + ".Values", "");
                } else if (!filtersListValue.values().isEmpty() && !(filtersListValue.values() instanceof SdkAutoConstructList)) {
                    List<String> valuesList = filtersListValue.values();
                    int valuesListIndex = 1;
                    for (String valuesListValue : valuesList) {
                        if (valuesListValue != null) {
                            request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringConversion.fromString((String)valuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeDbEngineVersionsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringConversion.fromInteger((Integer)describeDbEngineVersionsRequest.maxRecords()));
        }
        if (describeDbEngineVersionsRequest.marker() != null) {
            request.addParameter("Marker", StringConversion.fromString((String)describeDbEngineVersionsRequest.marker()));
        }
        if (describeDbEngineVersionsRequest.defaultOnly() != null) {
            request.addParameter("DefaultOnly", StringConversion.fromBoolean((Boolean)describeDbEngineVersionsRequest.defaultOnly()));
        }
        if (describeDbEngineVersionsRequest.listSupportedCharacterSets() != null) {
            request.addParameter("ListSupportedCharacterSets", StringConversion.fromBoolean((Boolean)describeDbEngineVersionsRequest.listSupportedCharacterSets()));
        }
        if (describeDbEngineVersionsRequest.listSupportedTimezones() != null) {
            request.addParameter("ListSupportedTimezones", StringConversion.fromBoolean((Boolean)describeDbEngineVersionsRequest.listSupportedTimezones()));
        }
        return request;
    }
}

