/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.rds.model.DBSubnetGroup;
import software.amazon.awssdk.services.rds.model.Subnet;
import software.amazon.awssdk.services.rds.transform.SubnetUnmarshaller;

public class DBSubnetGroupUnmarshaller
implements Unmarshaller<DBSubnetGroup, StaxUnmarshallerContext> {
    private static final DBSubnetGroupUnmarshaller INSTANCE = new DBSubnetGroupUnmarshaller();

    public DBSubnetGroup unmarshall(StaxUnmarshallerContext context) throws Exception {
        DBSubnetGroup.Builder dbSubnetGroup;
        block10: {
            dbSubnetGroup = DBSubnetGroup.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                targetDepth += 3;
            }
            ArrayList<Subnet> subnets = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    dbSubnetGroup.subnets(subnets);
                    break block10;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("DBSubnetGroupName", targetDepth)) {
                        dbSubnetGroup.dbSubnetGroupName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("DBSubnetGroupDescription", targetDepth)) {
                        dbSubnetGroup.dbSubnetGroupDescription(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("VpcId", targetDepth)) {
                        dbSubnetGroup.vpcId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("SubnetGroupStatus", targetDepth)) {
                        dbSubnetGroup.subnetGroupStatus(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Subnets", targetDepth)) {
                        subnets = new ArrayList<Subnet>();
                        continue;
                    }
                    if (context.testExpression("Subnets/Subnet", targetDepth)) {
                        subnets.add(SubnetUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("DBSubnetGroupArn", targetDepth)) continue;
                    dbSubnetGroup.dbSubnetGroupArn(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            dbSubnetGroup.subnets(subnets);
        }
        return (DBSubnetGroup)dbSubnetGroup.build();
    }

    public static DBSubnetGroupUnmarshaller getInstance() {
        return INSTANCE;
    }
}

