/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.rds.model.CreateDbInstanceRequest;
import software.amazon.awssdk.services.rds.model.Tag;

public class CreateDbInstanceRequestMarshaller
implements Marshaller<Request<CreateDbInstanceRequest>, CreateDbInstanceRequest> {
    public Request<CreateDbInstanceRequest> marshall(CreateDbInstanceRequest createDbInstanceRequest) {
        if (createDbInstanceRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createDbInstanceRequest, "RdsClient");
        request.addParameter("Action", "CreateDBInstance");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (createDbInstanceRequest.dbName() != null) {
            request.addParameter("DBName", StringConversion.fromString((String)createDbInstanceRequest.dbName()));
        }
        if (createDbInstanceRequest.dbInstanceIdentifier() != null) {
            request.addParameter("DBInstanceIdentifier", StringConversion.fromString((String)createDbInstanceRequest.dbInstanceIdentifier()));
        }
        if (createDbInstanceRequest.allocatedStorage() != null) {
            request.addParameter("AllocatedStorage", StringConversion.fromInteger((Integer)createDbInstanceRequest.allocatedStorage()));
        }
        if (createDbInstanceRequest.dbInstanceClass() != null) {
            request.addParameter("DBInstanceClass", StringConversion.fromString((String)createDbInstanceRequest.dbInstanceClass()));
        }
        if (createDbInstanceRequest.engine() != null) {
            request.addParameter("Engine", StringConversion.fromString((String)createDbInstanceRequest.engine()));
        }
        if (createDbInstanceRequest.masterUsername() != null) {
            request.addParameter("MasterUsername", StringConversion.fromString((String)createDbInstanceRequest.masterUsername()));
        }
        if (createDbInstanceRequest.masterUserPassword() != null) {
            request.addParameter("MasterUserPassword", StringConversion.fromString((String)createDbInstanceRequest.masterUserPassword()));
        }
        if (createDbInstanceRequest.dbSecurityGroups().isEmpty() && !(createDbInstanceRequest.dbSecurityGroups() instanceof SdkAutoConstructList)) {
            request.addParameter("DBSecurityGroups", "");
        } else if (!createDbInstanceRequest.dbSecurityGroups().isEmpty() && !(createDbInstanceRequest.dbSecurityGroups() instanceof SdkAutoConstructList)) {
            List<String> dBSecurityGroupsList = createDbInstanceRequest.dbSecurityGroups();
            int dBSecurityGroupsListIndex = 1;
            for (String dBSecurityGroupsListValue : dBSecurityGroupsList) {
                if (dBSecurityGroupsListValue != null) {
                    request.addParameter("DBSecurityGroups.DBSecurityGroupName." + dBSecurityGroupsListIndex, StringConversion.fromString((String)dBSecurityGroupsListValue));
                }
                ++dBSecurityGroupsListIndex;
            }
        }
        if (createDbInstanceRequest.vpcSecurityGroupIds().isEmpty() && !(createDbInstanceRequest.vpcSecurityGroupIds() instanceof SdkAutoConstructList)) {
            request.addParameter("VpcSecurityGroupIds", "");
        } else if (!createDbInstanceRequest.vpcSecurityGroupIds().isEmpty() && !(createDbInstanceRequest.vpcSecurityGroupIds() instanceof SdkAutoConstructList)) {
            List<String> vpcSecurityGroupIdsList = createDbInstanceRequest.vpcSecurityGroupIds();
            int vpcSecurityGroupIdsListIndex = 1;
            for (String vpcSecurityGroupIdsListValue : vpcSecurityGroupIdsList) {
                if (vpcSecurityGroupIdsListValue != null) {
                    request.addParameter("VpcSecurityGroupIds.VpcSecurityGroupId." + vpcSecurityGroupIdsListIndex, StringConversion.fromString((String)vpcSecurityGroupIdsListValue));
                }
                ++vpcSecurityGroupIdsListIndex;
            }
        }
        if (createDbInstanceRequest.availabilityZone() != null) {
            request.addParameter("AvailabilityZone", StringConversion.fromString((String)createDbInstanceRequest.availabilityZone()));
        }
        if (createDbInstanceRequest.dbSubnetGroupName() != null) {
            request.addParameter("DBSubnetGroupName", StringConversion.fromString((String)createDbInstanceRequest.dbSubnetGroupName()));
        }
        if (createDbInstanceRequest.preferredMaintenanceWindow() != null) {
            request.addParameter("PreferredMaintenanceWindow", StringConversion.fromString((String)createDbInstanceRequest.preferredMaintenanceWindow()));
        }
        if (createDbInstanceRequest.dbParameterGroupName() != null) {
            request.addParameter("DBParameterGroupName", StringConversion.fromString((String)createDbInstanceRequest.dbParameterGroupName()));
        }
        if (createDbInstanceRequest.backupRetentionPeriod() != null) {
            request.addParameter("BackupRetentionPeriod", StringConversion.fromInteger((Integer)createDbInstanceRequest.backupRetentionPeriod()));
        }
        if (createDbInstanceRequest.preferredBackupWindow() != null) {
            request.addParameter("PreferredBackupWindow", StringConversion.fromString((String)createDbInstanceRequest.preferredBackupWindow()));
        }
        if (createDbInstanceRequest.port() != null) {
            request.addParameter("Port", StringConversion.fromInteger((Integer)createDbInstanceRequest.port()));
        }
        if (createDbInstanceRequest.multiAZ() != null) {
            request.addParameter("MultiAZ", StringConversion.fromBoolean((Boolean)createDbInstanceRequest.multiAZ()));
        }
        if (createDbInstanceRequest.engineVersion() != null) {
            request.addParameter("EngineVersion", StringConversion.fromString((String)createDbInstanceRequest.engineVersion()));
        }
        if (createDbInstanceRequest.autoMinorVersionUpgrade() != null) {
            request.addParameter("AutoMinorVersionUpgrade", StringConversion.fromBoolean((Boolean)createDbInstanceRequest.autoMinorVersionUpgrade()));
        }
        if (createDbInstanceRequest.licenseModel() != null) {
            request.addParameter("LicenseModel", StringConversion.fromString((String)createDbInstanceRequest.licenseModel()));
        }
        if (createDbInstanceRequest.iops() != null) {
            request.addParameter("Iops", StringConversion.fromInteger((Integer)createDbInstanceRequest.iops()));
        }
        if (createDbInstanceRequest.optionGroupName() != null) {
            request.addParameter("OptionGroupName", StringConversion.fromString((String)createDbInstanceRequest.optionGroupName()));
        }
        if (createDbInstanceRequest.characterSetName() != null) {
            request.addParameter("CharacterSetName", StringConversion.fromString((String)createDbInstanceRequest.characterSetName()));
        }
        if (createDbInstanceRequest.publiclyAccessible() != null) {
            request.addParameter("PubliclyAccessible", StringConversion.fromBoolean((Boolean)createDbInstanceRequest.publiclyAccessible()));
        }
        if (createDbInstanceRequest.tags().isEmpty() && !(createDbInstanceRequest.tags() instanceof SdkAutoConstructList)) {
            request.addParameter("Tags", "");
        } else if (!createDbInstanceRequest.tags().isEmpty() && !(createDbInstanceRequest.tags() instanceof SdkAutoConstructList)) {
            List<Tag> tagsList = createDbInstanceRequest.tags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringConversion.fromString((String)tagsListValue.key()));
                }
                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringConversion.fromString((String)tagsListValue.value()));
                }
                ++tagsListIndex;
            }
        }
        if (createDbInstanceRequest.dbClusterIdentifier() != null) {
            request.addParameter("DBClusterIdentifier", StringConversion.fromString((String)createDbInstanceRequest.dbClusterIdentifier()));
        }
        if (createDbInstanceRequest.storageType() != null) {
            request.addParameter("StorageType", StringConversion.fromString((String)createDbInstanceRequest.storageType()));
        }
        if (createDbInstanceRequest.tdeCredentialArn() != null) {
            request.addParameter("TdeCredentialArn", StringConversion.fromString((String)createDbInstanceRequest.tdeCredentialArn()));
        }
        if (createDbInstanceRequest.tdeCredentialPassword() != null) {
            request.addParameter("TdeCredentialPassword", StringConversion.fromString((String)createDbInstanceRequest.tdeCredentialPassword()));
        }
        if (createDbInstanceRequest.storageEncrypted() != null) {
            request.addParameter("StorageEncrypted", StringConversion.fromBoolean((Boolean)createDbInstanceRequest.storageEncrypted()));
        }
        if (createDbInstanceRequest.kmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringConversion.fromString((String)createDbInstanceRequest.kmsKeyId()));
        }
        if (createDbInstanceRequest.domain() != null) {
            request.addParameter("Domain", StringConversion.fromString((String)createDbInstanceRequest.domain()));
        }
        if (createDbInstanceRequest.copyTagsToSnapshot() != null) {
            request.addParameter("CopyTagsToSnapshot", StringConversion.fromBoolean((Boolean)createDbInstanceRequest.copyTagsToSnapshot()));
        }
        if (createDbInstanceRequest.monitoringInterval() != null) {
            request.addParameter("MonitoringInterval", StringConversion.fromInteger((Integer)createDbInstanceRequest.monitoringInterval()));
        }
        if (createDbInstanceRequest.monitoringRoleArn() != null) {
            request.addParameter("MonitoringRoleArn", StringConversion.fromString((String)createDbInstanceRequest.monitoringRoleArn()));
        }
        if (createDbInstanceRequest.domainIAMRoleName() != null) {
            request.addParameter("DomainIAMRoleName", StringConversion.fromString((String)createDbInstanceRequest.domainIAMRoleName()));
        }
        if (createDbInstanceRequest.promotionTier() != null) {
            request.addParameter("PromotionTier", StringConversion.fromInteger((Integer)createDbInstanceRequest.promotionTier()));
        }
        if (createDbInstanceRequest.timezone() != null) {
            request.addParameter("Timezone", StringConversion.fromString((String)createDbInstanceRequest.timezone()));
        }
        if (createDbInstanceRequest.enableIAMDatabaseAuthentication() != null) {
            request.addParameter("EnableIAMDatabaseAuthentication", StringConversion.fromBoolean((Boolean)createDbInstanceRequest.enableIAMDatabaseAuthentication()));
        }
        if (createDbInstanceRequest.enablePerformanceInsights() != null) {
            request.addParameter("EnablePerformanceInsights", StringConversion.fromBoolean((Boolean)createDbInstanceRequest.enablePerformanceInsights()));
        }
        if (createDbInstanceRequest.performanceInsightsKMSKeyId() != null) {
            request.addParameter("PerformanceInsightsKMSKeyId", StringConversion.fromString((String)createDbInstanceRequest.performanceInsightsKMSKeyId()));
        }
        return request;
    }
}

