/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.rds.RdsClient;
import software.amazon.awssdk.services.rds.model.DescribeDBLogFilesDetails;
import software.amazon.awssdk.services.rds.model.DescribeDbLogFilesRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbLogFilesResponse;

public class DescribeDBLogFilesIterable
implements SdkIterable<DescribeDbLogFilesResponse> {
    private final RdsClient client;
    private final DescribeDbLogFilesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeDBLogFilesIterable(RdsClient client, DescribeDbLogFilesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeDbLogFilesResponseFetcher();
    }

    public Iterator<DescribeDbLogFilesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DescribeDBLogFilesDetails> describeDBLogFiles() {
        Function<DescribeDbLogFilesResponse, Iterator> getIterator = response -> {
            if (response != null && response.describeDBLogFiles() != null) {
                return response.describeDBLogFiles().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final DescribeDBLogFilesIterable resume(DescribeDbLogFilesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeDBLogFilesIterable(this.client, (DescribeDbLogFilesRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeDBLogFilesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeDbLogFilesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeDbLogFilesResponseFetcher
    implements SyncPageFetcher<DescribeDbLogFilesResponse> {
        private DescribeDbLogFilesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDbLogFilesResponse previousPage) {
            return previousPage.marker() != null && !SdkAutoConstructList.class.isInstance(previousPage.marker()) && !SdkAutoConstructMap.class.isInstance(previousPage.marker());
        }

        public DescribeDbLogFilesResponse nextPage(DescribeDbLogFilesResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBLogFilesIterable.this.client.describeDBLogFiles(DescribeDBLogFilesIterable.this.firstRequest);
            }
            return DescribeDBLogFilesIterable.this.client.describeDBLogFiles((DescribeDbLogFilesRequest)((Object)DescribeDBLogFilesIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

