/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.rds.RdsClient;
import software.amazon.awssdk.services.rds.model.DBInstance;
import software.amazon.awssdk.services.rds.model.DescribeDbInstancesRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbInstancesResponse;

public class DescribeDBInstancesIterable
implements SdkIterable<DescribeDbInstancesResponse> {
    private final RdsClient client;
    private final DescribeDbInstancesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeDBInstancesIterable(RdsClient client, DescribeDbInstancesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeDbInstancesResponseFetcher();
    }

    public Iterator<DescribeDbInstancesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DBInstance> dbInstances() {
        Function<DescribeDbInstancesResponse, Iterator> getIterator = response -> {
            if (response != null && response.dbInstances() != null) {
                return response.dbInstances().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final DescribeDBInstancesIterable resume(DescribeDbInstancesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeDBInstancesIterable(this.client, (DescribeDbInstancesRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeDBInstancesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeDbInstancesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeDbInstancesResponseFetcher
    implements SyncPageFetcher<DescribeDbInstancesResponse> {
        private DescribeDbInstancesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDbInstancesResponse previousPage) {
            return previousPage.marker() != null && !SdkAutoConstructList.class.isInstance(previousPage.marker()) && !SdkAutoConstructMap.class.isInstance(previousPage.marker());
        }

        public DescribeDbInstancesResponse nextPage(DescribeDbInstancesResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBInstancesIterable.this.client.describeDBInstances(DescribeDBInstancesIterable.this.firstRequest);
            }
            return DescribeDBInstancesIterable.this.client.describeDBInstances((DescribeDbInstancesRequest)((Object)DescribeDBInstancesIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

