/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.services.rds.model.Tag;
import software.amazon.awssdk.services.rds.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CopyDbClusterParameterGroupRequest
extends RdsRequest
implements ToCopyableBuilder<Builder, CopyDbClusterParameterGroupRequest> {
    private final String sourceDBClusterParameterGroupIdentifier;
    private final String targetDBClusterParameterGroupIdentifier;
    private final String targetDBClusterParameterGroupDescription;
    private final List<Tag> tags;

    private CopyDbClusterParameterGroupRequest(BuilderImpl builder) {
        super(builder);
        this.sourceDBClusterParameterGroupIdentifier = builder.sourceDBClusterParameterGroupIdentifier;
        this.targetDBClusterParameterGroupIdentifier = builder.targetDBClusterParameterGroupIdentifier;
        this.targetDBClusterParameterGroupDescription = builder.targetDBClusterParameterGroupDescription;
        this.tags = builder.tags;
    }

    public String sourceDBClusterParameterGroupIdentifier() {
        return this.sourceDBClusterParameterGroupIdentifier;
    }

    public String targetDBClusterParameterGroupIdentifier() {
        return this.targetDBClusterParameterGroupIdentifier;
    }

    public String targetDBClusterParameterGroupDescription() {
        return this.targetDBClusterParameterGroupDescription;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceDBClusterParameterGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetDBClusterParameterGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetDBClusterParameterGroupDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyDbClusterParameterGroupRequest)) {
            return false;
        }
        CopyDbClusterParameterGroupRequest other = (CopyDbClusterParameterGroupRequest)((Object)obj);
        return Objects.equals(this.sourceDBClusterParameterGroupIdentifier(), other.sourceDBClusterParameterGroupIdentifier()) && Objects.equals(this.targetDBClusterParameterGroupIdentifier(), other.targetDBClusterParameterGroupIdentifier()) && Objects.equals(this.targetDBClusterParameterGroupDescription(), other.targetDBClusterParameterGroupDescription()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CopyDbClusterParameterGroupRequest").add("SourceDBClusterParameterGroupIdentifier", (Object)this.sourceDBClusterParameterGroupIdentifier()).add("TargetDBClusterParameterGroupIdentifier", (Object)this.targetDBClusterParameterGroupIdentifier()).add("TargetDBClusterParameterGroupDescription", (Object)this.targetDBClusterParameterGroupDescription()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceDBClusterParameterGroupIdentifier": {
                return Optional.ofNullable(clazz.cast(this.sourceDBClusterParameterGroupIdentifier()));
            }
            case "TargetDBClusterParameterGroupIdentifier": {
                return Optional.ofNullable(clazz.cast(this.targetDBClusterParameterGroupIdentifier()));
            }
            case "TargetDBClusterParameterGroupDescription": {
                return Optional.ofNullable(clazz.cast(this.targetDBClusterParameterGroupDescription()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private String sourceDBClusterParameterGroupIdentifier;
        private String targetDBClusterParameterGroupIdentifier;
        private String targetDBClusterParameterGroupDescription;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CopyDbClusterParameterGroupRequest model) {
            super(model);
            this.sourceDBClusterParameterGroupIdentifier(model.sourceDBClusterParameterGroupIdentifier);
            this.targetDBClusterParameterGroupIdentifier(model.targetDBClusterParameterGroupIdentifier);
            this.targetDBClusterParameterGroupDescription(model.targetDBClusterParameterGroupDescription);
            this.tags(model.tags);
        }

        public final String getSourceDBClusterParameterGroupIdentifier() {
            return this.sourceDBClusterParameterGroupIdentifier;
        }

        @Override
        public final Builder sourceDBClusterParameterGroupIdentifier(String sourceDBClusterParameterGroupIdentifier) {
            this.sourceDBClusterParameterGroupIdentifier = sourceDBClusterParameterGroupIdentifier;
            return this;
        }

        public final void setSourceDBClusterParameterGroupIdentifier(String sourceDBClusterParameterGroupIdentifier) {
            this.sourceDBClusterParameterGroupIdentifier = sourceDBClusterParameterGroupIdentifier;
        }

        public final String getTargetDBClusterParameterGroupIdentifier() {
            return this.targetDBClusterParameterGroupIdentifier;
        }

        @Override
        public final Builder targetDBClusterParameterGroupIdentifier(String targetDBClusterParameterGroupIdentifier) {
            this.targetDBClusterParameterGroupIdentifier = targetDBClusterParameterGroupIdentifier;
            return this;
        }

        public final void setTargetDBClusterParameterGroupIdentifier(String targetDBClusterParameterGroupIdentifier) {
            this.targetDBClusterParameterGroupIdentifier = targetDBClusterParameterGroupIdentifier;
        }

        public final String getTargetDBClusterParameterGroupDescription() {
            return this.targetDBClusterParameterGroupDescription;
        }

        @Override
        public final Builder targetDBClusterParameterGroupDescription(String targetDBClusterParameterGroupDescription) {
            this.targetDBClusterParameterGroupDescription = targetDBClusterParameterGroupDescription;
            return this;
        }

        public final void setTargetDBClusterParameterGroupDescription(String targetDBClusterParameterGroupDescription) {
            this.targetDBClusterParameterGroupDescription = targetDBClusterParameterGroupDescription;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CopyDbClusterParameterGroupRequest build() {
            return new CopyDbClusterParameterGroupRequest(this);
        }
    }

    public static interface Builder
    extends RdsRequest.Builder,
    CopyableBuilder<Builder, CopyDbClusterParameterGroupRequest> {
        public Builder sourceDBClusterParameterGroupIdentifier(String var1);

        public Builder targetDBClusterParameterGroupIdentifier(String var1);

        public Builder targetDBClusterParameterGroupDescription(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

