/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.rds.model.CreateOptionGroupRequest;
import software.amazon.awssdk.services.rds.model.Tag;

public class CreateOptionGroupRequestMarshaller
implements Marshaller<Request<CreateOptionGroupRequest>, CreateOptionGroupRequest> {
    public Request<CreateOptionGroupRequest> marshall(CreateOptionGroupRequest createOptionGroupRequest) {
        List<Tag> tagsList;
        if (createOptionGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)createOptionGroupRequest, "RDSClient");
        request.addParameter("Action", "CreateOptionGroup");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (createOptionGroupRequest.optionGroupName() != null) {
            request.addParameter("OptionGroupName", StringUtils.fromString((String)createOptionGroupRequest.optionGroupName()));
        }
        if (createOptionGroupRequest.engineName() != null) {
            request.addParameter("EngineName", StringUtils.fromString((String)createOptionGroupRequest.engineName()));
        }
        if (createOptionGroupRequest.majorEngineVersion() != null) {
            request.addParameter("MajorEngineVersion", StringUtils.fromString((String)createOptionGroupRequest.majorEngineVersion()));
        }
        if (createOptionGroupRequest.optionGroupDescription() != null) {
            request.addParameter("OptionGroupDescription", StringUtils.fromString((String)createOptionGroupRequest.optionGroupDescription()));
        }
        if ((tagsList = createOptionGroupRequest.tags()) != null) {
            if (!tagsList.isEmpty()) {
                int tagsListIndex = 1;
                for (Tag tagsListValue : tagsList) {
                    if (tagsListValue.key() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.key()));
                    }
                    if (tagsListValue.value() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.value()));
                    }
                    ++tagsListIndex;
                }
            } else {
                request.addParameter("Tags", "");
            }
        }
        return request;
    }
}

