/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.rds.RDSAsyncClient;
import software.amazon.awssdk.services.rds.model.DescribeReservedDBInstancesOfferingsRequest;
import software.amazon.awssdk.services.rds.model.DescribeReservedDBInstancesOfferingsResponse;
import software.amazon.awssdk.services.rds.model.ReservedDBInstancesOffering;

public class DescribeReservedDBInstancesOfferingsPublisher
implements SdkPublisher<DescribeReservedDBInstancesOfferingsResponse> {
    private final RDSAsyncClient client;
    private final DescribeReservedDBInstancesOfferingsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeReservedDBInstancesOfferingsPublisher(RDSAsyncClient client, DescribeReservedDBInstancesOfferingsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeReservedDBInstancesOfferingsPublisher(RDSAsyncClient client, DescribeReservedDBInstancesOfferingsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeReservedDBInstancesOfferingsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeReservedDBInstancesOfferingsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<ReservedDBInstancesOffering> reservedDBInstancesOfferings() {
        Function<DescribeReservedDBInstancesOfferingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.reservedDBInstancesOfferings() != null) {
                return response.reservedDBInstancesOfferings().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new DescribeReservedDBInstancesOfferingsResponseFetcher(), getIterator, this.isLastPage);
    }

    public final DescribeReservedDBInstancesOfferingsPublisher resume(DescribeReservedDBInstancesOfferingsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeReservedDBInstancesOfferingsPublisher(this.client, (DescribeReservedDBInstancesOfferingsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeReservedDBInstancesOfferingsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeReservedDBInstancesOfferingsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeReservedDBInstancesOfferingsResponseFetcher
    implements AsyncPageFetcher<DescribeReservedDBInstancesOfferingsResponse> {
        private DescribeReservedDBInstancesOfferingsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReservedDBInstancesOfferingsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public CompletableFuture<DescribeReservedDBInstancesOfferingsResponse> nextPage(DescribeReservedDBInstancesOfferingsResponse previousPage) {
            if (previousPage == null) {
                return DescribeReservedDBInstancesOfferingsPublisher.this.client.describeReservedDBInstancesOfferings(DescribeReservedDBInstancesOfferingsPublisher.this.firstRequest);
            }
            return DescribeReservedDBInstancesOfferingsPublisher.this.client.describeReservedDBInstancesOfferings((DescribeReservedDBInstancesOfferingsRequest)((Object)DescribeReservedDBInstancesOfferingsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

