/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.rds.RDSAsyncClient;
import software.amazon.awssdk.services.rds.model.DescribeEventSubscriptionsRequest;
import software.amazon.awssdk.services.rds.model.DescribeEventSubscriptionsResponse;
import software.amazon.awssdk.services.rds.model.EventSubscription;

public class DescribeEventSubscriptionsPublisher
implements SdkPublisher<DescribeEventSubscriptionsResponse> {
    private final RDSAsyncClient client;
    private final DescribeEventSubscriptionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeEventSubscriptionsPublisher(RDSAsyncClient client, DescribeEventSubscriptionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeEventSubscriptionsPublisher(RDSAsyncClient client, DescribeEventSubscriptionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeEventSubscriptionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeEventSubscriptionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<EventSubscription> eventSubscriptionsList() {
        Function<DescribeEventSubscriptionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.eventSubscriptionsList() != null) {
                return response.eventSubscriptionsList().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new DescribeEventSubscriptionsResponseFetcher(), getIterator, this.isLastPage);
    }

    public final DescribeEventSubscriptionsPublisher resume(DescribeEventSubscriptionsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeEventSubscriptionsPublisher(this.client, (DescribeEventSubscriptionsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeEventSubscriptionsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeEventSubscriptionsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeEventSubscriptionsResponseFetcher
    implements AsyncPageFetcher<DescribeEventSubscriptionsResponse> {
        private DescribeEventSubscriptionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeEventSubscriptionsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public CompletableFuture<DescribeEventSubscriptionsResponse> nextPage(DescribeEventSubscriptionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeEventSubscriptionsPublisher.this.client.describeEventSubscriptions(DescribeEventSubscriptionsPublisher.this.firstRequest);
            }
            return DescribeEventSubscriptionsPublisher.this.client.describeEventSubscriptions((DescribeEventSubscriptionsRequest)((Object)DescribeEventSubscriptionsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

