/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.rds.RDSClient;
import software.amazon.awssdk.services.rds.model.DBInstance;
import software.amazon.awssdk.services.rds.model.DescribeDBInstancesRequest;
import software.amazon.awssdk.services.rds.model.DescribeDBInstancesResponse;

public class DescribeDBInstancesIterable
implements SdkIterable<DescribeDBInstancesResponse> {
    private final RDSClient client;
    private final DescribeDBInstancesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeDBInstancesIterable(RDSClient client, DescribeDBInstancesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeDBInstancesResponseFetcher();
    }

    public Iterator<DescribeDBInstancesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<DBInstance> dbInstances() {
        Function<DescribeDBInstancesResponse, Iterator> getIterator = response -> {
            if (response != null && response.dbInstances() != null) {
                return response.dbInstances().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final DescribeDBInstancesIterable resume(DescribeDBInstancesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeDBInstancesIterable(this.client, (DescribeDBInstancesRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeDBInstancesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeDBInstancesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeDBInstancesResponseFetcher
    implements SyncPageFetcher<DescribeDBInstancesResponse> {
        private DescribeDBInstancesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDBInstancesResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeDBInstancesResponse nextPage(DescribeDBInstancesResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBInstancesIterable.this.client.describeDBInstances(DescribeDBInstancesIterable.this.firstRequest);
            }
            return DescribeDBInstancesIterable.this.client.describeDBInstances((DescribeDBInstancesRequest)((Object)DescribeDBInstancesIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

