/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.rds.model.DoubleRange;
import software.amazon.awssdk.services.rds.model.DoubleRangeListCopier;
import software.amazon.awssdk.services.rds.model.Range;
import software.amazon.awssdk.services.rds.model.RangeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ValidStorageOptions
implements ToCopyableBuilder<Builder, ValidStorageOptions> {
    private final String storageType;
    private final List<Range> storageSize;
    private final List<Range> provisionedIops;
    private final List<DoubleRange> iopsToStorageRatio;

    private ValidStorageOptions(BuilderImpl builder) {
        this.storageType = builder.storageType;
        this.storageSize = builder.storageSize;
        this.provisionedIops = builder.provisionedIops;
        this.iopsToStorageRatio = builder.iopsToStorageRatio;
    }

    public String storageType() {
        return this.storageType;
    }

    public List<Range> storageSize() {
        return this.storageSize;
    }

    public List<Range> provisionedIops() {
        return this.provisionedIops;
    }

    public List<DoubleRange> iopsToStorageRatio() {
        return this.iopsToStorageRatio;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.storageType());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedIops());
        hashCode = 31 * hashCode + Objects.hashCode(this.iopsToStorageRatio());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidStorageOptions)) {
            return false;
        }
        ValidStorageOptions other = (ValidStorageOptions)obj;
        return Objects.equals(this.storageType(), other.storageType()) && Objects.equals(this.storageSize(), other.storageSize()) && Objects.equals(this.provisionedIops(), other.provisionedIops()) && Objects.equals(this.iopsToStorageRatio(), other.iopsToStorageRatio());
    }

    public String toString() {
        return ToString.builder((String)"ValidStorageOptions").add("StorageType", (Object)this.storageType()).add("StorageSize", this.storageSize()).add("ProvisionedIops", this.provisionedIops()).add("IopsToStorageRatio", this.iopsToStorageRatio()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StorageType": {
                return Optional.of(clazz.cast(this.storageType()));
            }
            case "StorageSize": {
                return Optional.of(clazz.cast(this.storageSize()));
            }
            case "ProvisionedIops": {
                return Optional.of(clazz.cast(this.provisionedIops()));
            }
            case "IopsToStorageRatio": {
                return Optional.of(clazz.cast(this.iopsToStorageRatio()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String storageType;
        private List<Range> storageSize;
        private List<Range> provisionedIops;
        private List<DoubleRange> iopsToStorageRatio;

        private BuilderImpl() {
        }

        private BuilderImpl(ValidStorageOptions model) {
            this.storageType(model.storageType);
            this.storageSize(model.storageSize);
            this.provisionedIops(model.provisionedIops);
            this.iopsToStorageRatio(model.iopsToStorageRatio);
        }

        public final String getStorageType() {
            return this.storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        public final Collection<Range.Builder> getStorageSize() {
            return this.storageSize != null ? (Collection)this.storageSize.stream().map(Range::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder storageSize(Collection<Range> storageSize) {
            this.storageSize = RangeListCopier.copy(storageSize);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageSize(Range ... storageSize) {
            this.storageSize(Arrays.asList(storageSize));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageSize(Consumer<Range.Builder> ... storageSize) {
            this.storageSize(Stream.of(storageSize).map(c -> (Range)((Range.Builder)Range.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStorageSize(Collection<Range.BuilderImpl> storageSize) {
            this.storageSize = RangeListCopier.copyFromBuilder(storageSize);
        }

        public final Collection<Range.Builder> getProvisionedIops() {
            return this.provisionedIops != null ? (Collection)this.provisionedIops.stream().map(Range::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder provisionedIops(Collection<Range> provisionedIops) {
            this.provisionedIops = RangeListCopier.copy(provisionedIops);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisionedIops(Range ... provisionedIops) {
            this.provisionedIops(Arrays.asList(provisionedIops));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisionedIops(Consumer<Range.Builder> ... provisionedIops) {
            this.provisionedIops(Stream.of(provisionedIops).map(c -> (Range)((Range.Builder)Range.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProvisionedIops(Collection<Range.BuilderImpl> provisionedIops) {
            this.provisionedIops = RangeListCopier.copyFromBuilder(provisionedIops);
        }

        public final Collection<DoubleRange.Builder> getIopsToStorageRatio() {
            return this.iopsToStorageRatio != null ? (Collection)this.iopsToStorageRatio.stream().map(DoubleRange::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder iopsToStorageRatio(Collection<DoubleRange> iopsToStorageRatio) {
            this.iopsToStorageRatio = DoubleRangeListCopier.copy(iopsToStorageRatio);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder iopsToStorageRatio(DoubleRange ... iopsToStorageRatio) {
            this.iopsToStorageRatio(Arrays.asList(iopsToStorageRatio));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder iopsToStorageRatio(Consumer<DoubleRange.Builder> ... iopsToStorageRatio) {
            this.iopsToStorageRatio(Stream.of(iopsToStorageRatio).map(c -> (DoubleRange)((DoubleRange.Builder)DoubleRange.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIopsToStorageRatio(Collection<DoubleRange.BuilderImpl> iopsToStorageRatio) {
            this.iopsToStorageRatio = DoubleRangeListCopier.copyFromBuilder(iopsToStorageRatio);
        }

        public ValidStorageOptions build() {
            return new ValidStorageOptions(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ValidStorageOptions> {
        public Builder storageType(String var1);

        public Builder storageSize(Collection<Range> var1);

        public Builder storageSize(Range ... var1);

        public Builder storageSize(Consumer<Range.Builder> ... var1);

        public Builder provisionedIops(Collection<Range> var1);

        public Builder provisionedIops(Range ... var1);

        public Builder provisionedIops(Consumer<Range.Builder> ... var1);

        public Builder iopsToStorageRatio(Collection<DoubleRange> var1);

        public Builder iopsToStorageRatio(DoubleRange ... var1);

        public Builder iopsToStorageRatio(Consumer<DoubleRange.Builder> ... var1);
    }
}

