/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.rds.model.DBCluster;
import software.amazon.awssdk.services.rds.model.DBClusterListCopier;
import software.amazon.awssdk.services.rds.model.RDSResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeDBClustersResponse
extends RDSResponse
implements ToCopyableBuilder<Builder, DescribeDBClustersResponse> {
    private final String marker;
    private final List<DBCluster> dbClusters;

    private DescribeDBClustersResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.dbClusters = builder.dbClusters;
    }

    public String marker() {
        return this.marker;
    }

    public List<DBCluster> dbClusters() {
        return this.dbClusters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusters());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDBClustersResponse)) {
            return false;
        }
        DescribeDBClustersResponse other = (DescribeDBClustersResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && Objects.equals(this.dbClusters(), other.dbClusters());
    }

    public String toString() {
        return ToString.builder((String)"DescribeDBClustersResponse").add("Marker", (Object)this.marker()).add("DBClusters", this.dbClusters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "DBClusters": {
                return Optional.of(clazz.cast(this.dbClusters()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RDSResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<DBCluster> dbClusters;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDBClustersResponse model) {
            super(model);
            this.marker(model.marker);
            this.dbClusters(model.dbClusters);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<DBCluster.Builder> getDBClusters() {
            return this.dbClusters != null ? (Collection)this.dbClusters.stream().map(DBCluster::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dbClusters(Collection<DBCluster> dbClusters) {
            this.dbClusters = DBClusterListCopier.copy(dbClusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusters(DBCluster ... dbClusters) {
            this.dbClusters(Arrays.asList(dbClusters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusters(Consumer<DBCluster.Builder> ... dbClusters) {
            this.dbClusters(Stream.of(dbClusters).map(c -> (DBCluster)((DBCluster.Builder)DBCluster.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDBClusters(Collection<DBCluster.BuilderImpl> dbClusters) {
            this.dbClusters = DBClusterListCopier.copyFromBuilder(dbClusters);
        }

        @Override
        public DescribeDBClustersResponse build() {
            return new DescribeDBClustersResponse(this);
        }
    }

    public static interface Builder
    extends RDSResponse.Builder,
    CopyableBuilder<Builder, DescribeDBClustersResponse> {
        public Builder marker(String var1);

        public Builder dbClusters(Collection<DBCluster> var1);

        public Builder dbClusters(DBCluster ... var1);

        public Builder dbClusters(Consumer<DBCluster.Builder> ... var1);
    }
}

