/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.rds.model.DBSecurityGroupMembership;
import software.amazon.awssdk.services.rds.model.Option;
import software.amazon.awssdk.services.rds.model.OptionSetting;
import software.amazon.awssdk.services.rds.model.VpcSecurityGroupMembership;
import software.amazon.awssdk.services.rds.transform.DBSecurityGroupMembershipUnmarshaller;
import software.amazon.awssdk.services.rds.transform.OptionSettingUnmarshaller;
import software.amazon.awssdk.services.rds.transform.VpcSecurityGroupMembershipUnmarshaller;

public class OptionUnmarshaller
implements Unmarshaller<Option, StaxUnmarshallerContext> {
    private static OptionUnmarshaller INSTANCE;

    public Option unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        Option.Builder option = Option.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("OptionName", targetDepth)) {
                    option.optionName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("OptionDescription", targetDepth)) {
                    option.optionDescription(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Persistent", targetDepth)) {
                    option.persistent(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Permanent", targetDepth)) {
                    option.permanent(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Port", targetDepth)) {
                    option.port(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("OptionVersion", targetDepth)) {
                    option.optionVersion(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("OptionSettings", targetDepth)) {
                    option.optionSettings(new ArrayList<OptionSetting>());
                    continue;
                }
                if (context.testExpression("OptionSettings/OptionSetting", targetDepth)) {
                    option.optionSettings(OptionSettingUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DBSecurityGroupMemberships", targetDepth)) {
                    option.dbSecurityGroupMemberships(new ArrayList<DBSecurityGroupMembership>());
                    continue;
                }
                if (context.testExpression("DBSecurityGroupMemberships/DBSecurityGroup", targetDepth)) {
                    option.dbSecurityGroupMemberships(DBSecurityGroupMembershipUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("VpcSecurityGroupMemberships", targetDepth)) {
                    option.vpcSecurityGroupMemberships(new ArrayList<VpcSecurityGroupMembership>());
                    continue;
                }
                if (!context.testExpression("VpcSecurityGroupMemberships/VpcSecurityGroupMembership", targetDepth)) continue;
                option.vpcSecurityGroupMemberships(VpcSecurityGroupMembershipUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (Option)option.build();
    }

    public static OptionUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new OptionUnmarshaller();
        }
        return INSTANCE;
    }
}

