/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.rds.model.DescribeReservedDBInstancesOfferingsRequest;
import software.amazon.awssdk.services.rds.model.Filter;
import software.amazon.awssdk.util.StringUtils;

public class DescribeReservedDBInstancesOfferingsRequestMarshaller
implements Marshaller<Request<DescribeReservedDBInstancesOfferingsRequest>, DescribeReservedDBInstancesOfferingsRequest> {
    public Request<DescribeReservedDBInstancesOfferingsRequest> marshall(DescribeReservedDBInstancesOfferingsRequest describeReservedDBInstancesOfferingsRequest) {
        SdkInternalList filtersList;
        if (describeReservedDBInstancesOfferingsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeReservedDBInstancesOfferingsRequest, "RDSClient");
        request.addParameter("Action", "DescribeReservedDBInstancesOfferings");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeReservedDBInstancesOfferingsRequest.reservedDBInstancesOfferingId() != null) {
            request.addParameter("ReservedDBInstancesOfferingId", StringUtils.fromString((String)describeReservedDBInstancesOfferingsRequest.reservedDBInstancesOfferingId()));
        }
        if (describeReservedDBInstancesOfferingsRequest.dbInstanceClass() != null) {
            request.addParameter("DBInstanceClass", StringUtils.fromString((String)describeReservedDBInstancesOfferingsRequest.dbInstanceClass()));
        }
        if (describeReservedDBInstancesOfferingsRequest.duration() != null) {
            request.addParameter("Duration", StringUtils.fromString((String)describeReservedDBInstancesOfferingsRequest.duration()));
        }
        if (describeReservedDBInstancesOfferingsRequest.productDescription() != null) {
            request.addParameter("ProductDescription", StringUtils.fromString((String)describeReservedDBInstancesOfferingsRequest.productDescription()));
        }
        if (describeReservedDBInstancesOfferingsRequest.offeringType() != null) {
            request.addParameter("OfferingType", StringUtils.fromString((String)describeReservedDBInstancesOfferingsRequest.offeringType()));
        }
        if (describeReservedDBInstancesOfferingsRequest.multiAZ() != null) {
            request.addParameter("MultiAZ", StringUtils.fromBoolean((Boolean)describeReservedDBInstancesOfferingsRequest.multiAZ()));
        }
        if (!(filtersList = (SdkInternalList)describeReservedDBInstancesOfferingsRequest.filters()).isEmpty() || !filtersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter filtersListValue : filtersList) {
                SdkInternalList valuesList;
                if (filtersListValue.name() != null) {
                    request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filtersListValue.name()));
                }
                if (!(valuesList = (SdkInternalList)filtersListValue.values()).isEmpty() || !valuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String valuesListValue : valuesList) {
                        if (valuesListValue != null) {
                            request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeReservedDBInstancesOfferingsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeReservedDBInstancesOfferingsRequest.maxRecords()));
        }
        if (describeReservedDBInstancesOfferingsRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeReservedDBInstancesOfferingsRequest.marker()));
        }
        return request;
    }
}

