/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.rds.model.CopyDBSnapshotRequest;
import software.amazon.awssdk.services.rds.model.Tag;
import software.amazon.awssdk.util.StringUtils;

public class CopyDBSnapshotRequestMarshaller
implements Marshaller<Request<CopyDBSnapshotRequest>, CopyDBSnapshotRequest> {
    public Request<CopyDBSnapshotRequest> marshall(CopyDBSnapshotRequest copyDBSnapshotRequest) {
        SdkInternalList tagsList;
        if (copyDBSnapshotRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)copyDBSnapshotRequest, "RDSClient");
        request.addParameter("Action", "CopyDBSnapshot");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (copyDBSnapshotRequest.sourceDBSnapshotIdentifier() != null) {
            request.addParameter("SourceDBSnapshotIdentifier", StringUtils.fromString((String)copyDBSnapshotRequest.sourceDBSnapshotIdentifier()));
        }
        if (copyDBSnapshotRequest.targetDBSnapshotIdentifier() != null) {
            request.addParameter("TargetDBSnapshotIdentifier", StringUtils.fromString((String)copyDBSnapshotRequest.targetDBSnapshotIdentifier()));
        }
        if (copyDBSnapshotRequest.kmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringUtils.fromString((String)copyDBSnapshotRequest.kmsKeyId()));
        }
        if (!(tagsList = (SdkInternalList)copyDBSnapshotRequest.tags()).isEmpty() || !tagsList.isAutoConstruct()) {
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.key()));
                }
                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.value()));
                }
                ++tagsListIndex;
            }
        }
        if (copyDBSnapshotRequest.copyTags() != null) {
            request.addParameter("CopyTags", StringUtils.fromBoolean((Boolean)copyDBSnapshotRequest.copyTags()));
        }
        if (copyDBSnapshotRequest.preSignedUrl() != null) {
            request.addParameter("PreSignedUrl", StringUtils.fromString((String)copyDBSnapshotRequest.preSignedUrl()));
        }
        if (copyDBSnapshotRequest.optionGroupName() != null) {
            request.addParameter("OptionGroupName", StringUtils.fromString((String)copyDBSnapshotRequest.optionGroupName()));
        }
        if (copyDBSnapshotRequest.sourceRegion() != null) {
            request.addParameter("SourceRegion", StringUtils.fromString((String)copyDBSnapshotRequest.sourceRegion()));
        }
        return request;
    }
}

