/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.rds.model.DBInstance;
import software.amazon.awssdk.services.rds.model.DBInstanceListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeDBInstancesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeDBInstancesResponse> {
    private final String marker;
    private final List<DBInstance> dbInstances;

    private DescribeDBInstancesResponse(BuilderImpl builder) {
        this.marker = builder.marker;
        this.dbInstances = builder.dbInstances;
    }

    public String marker() {
        return this.marker;
    }

    public List<DBInstance> dbInstances() {
        return this.dbInstances;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        hashCode = 31 * hashCode + (this.dbInstances() == null ? 0 : this.dbInstances().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDBInstancesResponse)) {
            return false;
        }
        DescribeDBInstancesResponse other = (DescribeDBInstancesResponse)((Object)obj);
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.dbInstances() == null ^ this.dbInstances() == null) {
            return false;
        }
        return other.dbInstances() == null || other.dbInstances().equals(this.dbInstances());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.dbInstances() != null) {
            sb.append("DBInstances: ").append(this.dbInstances()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String marker;
        private List<DBInstance> dbInstances = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDBInstancesResponse model) {
            this.setMarker(model.marker);
            this.setDBInstances(model.dbInstances);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<DBInstance> getDBInstances() {
            return this.dbInstances;
        }

        @Override
        public final Builder dbInstances(Collection<DBInstance> dbInstances) {
            this.dbInstances = DBInstanceListCopier.copy(dbInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbInstances(DBInstance ... dbInstances) {
            if (this.dbInstances == null) {
                this.dbInstances = new SdkInternalList(dbInstances.length);
            }
            for (DBInstance e : dbInstances) {
                this.dbInstances.add(e);
            }
            return this;
        }

        public final void setDBInstances(Collection<DBInstance> dbInstances) {
            this.dbInstances = DBInstanceListCopier.copy(dbInstances);
        }

        @SafeVarargs
        public final void setDBInstances(DBInstance ... dbInstances) {
            if (this.dbInstances == null) {
                this.dbInstances = new SdkInternalList(dbInstances.length);
            }
            for (DBInstance e : dbInstances) {
                this.dbInstances.add(e);
            }
        }

        public DescribeDBInstancesResponse build() {
            return new DescribeDBInstancesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeDBInstancesResponse> {
        public Builder marker(String var1);

        public Builder dbInstances(Collection<DBInstance> var1);

        public Builder dbInstances(DBInstance ... var1);
    }
}

