/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rbin.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rbin.RbinClient;
import software.amazon.awssdk.services.rbin.model.ListRulesRequest;
import software.amazon.awssdk.services.rbin.model.ListRulesResponse;
import software.amazon.awssdk.services.rbin.model.RuleSummary;

public class ListRulesIterable
implements SdkIterable<ListRulesResponse> {
    private final RbinClient client;
    private final ListRulesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRulesIterable(RbinClient client, ListRulesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListRulesResponseFetcher();
    }

    public Iterator<ListRulesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RuleSummary> rules() {
        Function<ListRulesResponse, Iterator> getIterator = response -> {
            if (response != null && response.rules() != null) {
                return response.rules().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRulesResponseFetcher
    implements SyncPageFetcher<ListRulesResponse> {
        private ListRulesResponseFetcher() {
        }

        public boolean hasNextPage(ListRulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRulesResponse nextPage(ListRulesResponse previousPage) {
            if (previousPage == null) {
                return ListRulesIterable.this.client.listRules(ListRulesIterable.this.firstRequest);
            }
            return ListRulesIterable.this.client.listRules((ListRulesRequest)((Object)ListRulesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

