/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rbin;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.rbin.DefaultRbinAsyncClient;
import software.amazon.awssdk.services.rbin.DefaultRbinBaseClientBuilder;
import software.amazon.awssdk.services.rbin.RbinAsyncClient;
import software.amazon.awssdk.services.rbin.RbinAsyncClientBuilder;
import software.amazon.awssdk.services.rbin.RbinServiceClientConfiguration;
import software.amazon.awssdk.services.rbin.endpoints.RbinEndpointProvider;

@SdkInternalApi
final class DefaultRbinAsyncClientBuilder
extends DefaultRbinBaseClientBuilder<RbinAsyncClientBuilder, RbinAsyncClient>
implements RbinAsyncClientBuilder {
    DefaultRbinAsyncClientBuilder() {
    }

    @Override
    public DefaultRbinAsyncClientBuilder endpointProvider(RbinEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final RbinAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultRbinAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        RbinServiceClientConfiguration serviceClientConfiguration = RbinServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultRbinAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

