/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ram.RamAsyncClient;
import software.amazon.awssdk.services.ram.model.GetResourceShareAssociationsRequest;
import software.amazon.awssdk.services.ram.model.GetResourceShareAssociationsResponse;

public class GetResourceShareAssociationsPublisher
implements SdkPublisher<GetResourceShareAssociationsResponse> {
    private final RamAsyncClient client;
    private final GetResourceShareAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetResourceShareAssociationsPublisher(RamAsyncClient client, GetResourceShareAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetResourceShareAssociationsPublisher(RamAsyncClient client, GetResourceShareAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetResourceShareAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetResourceShareAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetResourceShareAssociationsResponseFetcher
    implements AsyncPageFetcher<GetResourceShareAssociationsResponse> {
        private GetResourceShareAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(GetResourceShareAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetResourceShareAssociationsResponse> nextPage(GetResourceShareAssociationsResponse previousPage) {
            if (previousPage == null) {
                return GetResourceShareAssociationsPublisher.this.client.getResourceShareAssociations(GetResourceShareAssociationsPublisher.this.firstRequest);
            }
            return GetResourceShareAssociationsPublisher.this.client.getResourceShareAssociations((GetResourceShareAssociationsRequest)((Object)GetResourceShareAssociationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

