/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ram.model.RamRequest;
import software.amazon.awssdk.services.ram.model.ResourceArnListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetResourcePoliciesRequest
extends RamRequest
implements ToCopyableBuilder<Builder, GetResourcePoliciesRequest> {
    private static final SdkField<List<String>> RESOURCE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resourceArns").getter(GetResourcePoliciesRequest.getter(GetResourcePoliciesRequest::resourceArns)).setter(GetResourcePoliciesRequest.setter(Builder::resourceArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PRINCIPAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("principal").getter(GetResourcePoliciesRequest.getter(GetResourcePoliciesRequest::principal)).setter(GetResourcePoliciesRequest.setter(Builder::principal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principal").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetResourcePoliciesRequest.getter(GetResourcePoliciesRequest::nextToken)).setter(GetResourcePoliciesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(GetResourcePoliciesRequest.getter(GetResourcePoliciesRequest::maxResults)).setter(GetResourcePoliciesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARNS_FIELD, PRINCIPAL_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetResourcePoliciesRequest.memberNameToFieldInitializer();
    private final List<String> resourceArns;
    private final String principal;
    private final String nextToken;
    private final Integer maxResults;

    private GetResourcePoliciesRequest(BuilderImpl builder) {
        super(builder);
        this.resourceArns = builder.resourceArns;
        this.principal = builder.principal;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final boolean hasResourceArns() {
        return this.resourceArns != null && !(this.resourceArns instanceof SdkAutoConstructList);
    }

    public final List<String> resourceArns() {
        return this.resourceArns;
    }

    public final String principal() {
        return this.principal;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceArns() ? this.resourceArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.principal());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourcePoliciesRequest)) {
            return false;
        }
        GetResourcePoliciesRequest other = (GetResourcePoliciesRequest)((Object)obj);
        return this.hasResourceArns() == other.hasResourceArns() && Objects.equals(this.resourceArns(), other.resourceArns()) && Objects.equals(this.principal(), other.principal()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"GetResourcePoliciesRequest").add("ResourceArns", this.hasResourceArns() ? this.resourceArns() : null).add("Principal", (Object)this.principal()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceArns": {
                return Optional.ofNullable(clazz.cast(this.resourceArns()));
            }
            case "principal": {
                return Optional.ofNullable(clazz.cast(this.principal()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("resourceArns", RESOURCE_ARNS_FIELD);
        map.put("principal", PRINCIPAL_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetResourcePoliciesRequest, T> g) {
        return obj -> g.apply((GetResourcePoliciesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RamRequest.BuilderImpl
    implements Builder {
        private List<String> resourceArns = DefaultSdkAutoConstructList.getInstance();
        private String principal;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourcePoliciesRequest model) {
            super(model);
            this.resourceArns(model.resourceArns);
            this.principal(model.principal);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final Collection<String> getResourceArns() {
            if (this.resourceArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceArns;
        }

        public final void setResourceArns(Collection<String> resourceArns) {
            this.resourceArns = ResourceArnListCopier.copy(resourceArns);
        }

        @Override
        public final Builder resourceArns(Collection<String> resourceArns) {
            this.resourceArns = ResourceArnListCopier.copy(resourceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceArns(String ... resourceArns) {
            this.resourceArns(Arrays.asList(resourceArns));
            return this;
        }

        public final String getPrincipal() {
            return this.principal;
        }

        public final void setPrincipal(String principal) {
            this.principal = principal;
        }

        @Override
        public final Builder principal(String principal) {
            this.principal = principal;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetResourcePoliciesRequest build() {
            return new GetResourcePoliciesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetResourcePoliciesRequest> {
        public Builder resourceArns(Collection<String> var1);

        public Builder resourceArns(String ... var1);

        public Builder principal(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

