/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ram.model.RamRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateResourceSharePermissionRequest
extends RamRequest
implements ToCopyableBuilder<Builder, AssociateResourceSharePermissionRequest> {
    private static final SdkField<String> RESOURCE_SHARE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceShareArn").getter(AssociateResourceSharePermissionRequest.getter(AssociateResourceSharePermissionRequest::resourceShareArn)).setter(AssociateResourceSharePermissionRequest.setter(Builder::resourceShareArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceShareArn").build()}).build();
    private static final SdkField<String> PERMISSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("permissionArn").getter(AssociateResourceSharePermissionRequest.getter(AssociateResourceSharePermissionRequest::permissionArn)).setter(AssociateResourceSharePermissionRequest.setter(Builder::permissionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissionArn").build()}).build();
    private static final SdkField<Boolean> REPLACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("replace").getter(AssociateResourceSharePermissionRequest.getter(AssociateResourceSharePermissionRequest::replace)).setter(AssociateResourceSharePermissionRequest.setter(Builder::replace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replace").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(AssociateResourceSharePermissionRequest.getter(AssociateResourceSharePermissionRequest::clientToken)).setter(AssociateResourceSharePermissionRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()}).build();
    private static final SdkField<Integer> PERMISSION_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("permissionVersion").getter(AssociateResourceSharePermissionRequest.getter(AssociateResourceSharePermissionRequest::permissionVersion)).setter(AssociateResourceSharePermissionRequest.setter(Builder::permissionVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissionVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_SHARE_ARN_FIELD, PERMISSION_ARN_FIELD, REPLACE_FIELD, CLIENT_TOKEN_FIELD, PERMISSION_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AssociateResourceSharePermissionRequest.memberNameToFieldInitializer();
    private final String resourceShareArn;
    private final String permissionArn;
    private final Boolean replace;
    private final String clientToken;
    private final Integer permissionVersion;

    private AssociateResourceSharePermissionRequest(BuilderImpl builder) {
        super(builder);
        this.resourceShareArn = builder.resourceShareArn;
        this.permissionArn = builder.permissionArn;
        this.replace = builder.replace;
        this.clientToken = builder.clientToken;
        this.permissionVersion = builder.permissionVersion;
    }

    public final String resourceShareArn() {
        return this.resourceShareArn;
    }

    public final String permissionArn() {
        return this.permissionArn;
    }

    public final Boolean replace() {
        return this.replace;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final Integer permissionVersion() {
        return this.permissionVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceShareArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.replace());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateResourceSharePermissionRequest)) {
            return false;
        }
        AssociateResourceSharePermissionRequest other = (AssociateResourceSharePermissionRequest)((Object)obj);
        return Objects.equals(this.resourceShareArn(), other.resourceShareArn()) && Objects.equals(this.permissionArn(), other.permissionArn()) && Objects.equals(this.replace(), other.replace()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.permissionVersion(), other.permissionVersion());
    }

    public final String toString() {
        return ToString.builder((String)"AssociateResourceSharePermissionRequest").add("ResourceShareArn", (Object)this.resourceShareArn()).add("PermissionArn", (Object)this.permissionArn()).add("Replace", (Object)this.replace()).add("ClientToken", (Object)this.clientToken()).add("PermissionVersion", (Object)this.permissionVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceShareArn": {
                return Optional.ofNullable(clazz.cast(this.resourceShareArn()));
            }
            case "permissionArn": {
                return Optional.ofNullable(clazz.cast(this.permissionArn()));
            }
            case "replace": {
                return Optional.ofNullable(clazz.cast(this.replace()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "permissionVersion": {
                return Optional.ofNullable(clazz.cast(this.permissionVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("resourceShareArn", RESOURCE_SHARE_ARN_FIELD);
        map.put("permissionArn", PERMISSION_ARN_FIELD);
        map.put("replace", REPLACE_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("permissionVersion", PERMISSION_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateResourceSharePermissionRequest, T> g) {
        return obj -> g.apply((AssociateResourceSharePermissionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RamRequest.BuilderImpl
    implements Builder {
        private String resourceShareArn;
        private String permissionArn;
        private Boolean replace;
        private String clientToken;
        private Integer permissionVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateResourceSharePermissionRequest model) {
            super(model);
            this.resourceShareArn(model.resourceShareArn);
            this.permissionArn(model.permissionArn);
            this.replace(model.replace);
            this.clientToken(model.clientToken);
            this.permissionVersion(model.permissionVersion);
        }

        public final String getResourceShareArn() {
            return this.resourceShareArn;
        }

        public final void setResourceShareArn(String resourceShareArn) {
            this.resourceShareArn = resourceShareArn;
        }

        @Override
        public final Builder resourceShareArn(String resourceShareArn) {
            this.resourceShareArn = resourceShareArn;
            return this;
        }

        public final String getPermissionArn() {
            return this.permissionArn;
        }

        public final void setPermissionArn(String permissionArn) {
            this.permissionArn = permissionArn;
        }

        @Override
        public final Builder permissionArn(String permissionArn) {
            this.permissionArn = permissionArn;
            return this;
        }

        public final Boolean getReplace() {
            return this.replace;
        }

        public final void setReplace(Boolean replace) {
            this.replace = replace;
        }

        @Override
        public final Builder replace(Boolean replace) {
            this.replace = replace;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Integer getPermissionVersion() {
            return this.permissionVersion;
        }

        public final void setPermissionVersion(Integer permissionVersion) {
            this.permissionVersion = permissionVersion;
        }

        @Override
        public final Builder permissionVersion(Integer permissionVersion) {
            this.permissionVersion = permissionVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateResourceSharePermissionRequest build() {
            return new AssociateResourceSharePermissionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateResourceSharePermissionRequest> {
        public Builder resourceShareArn(String var1);

        public Builder permissionArn(String var1);

        public Builder replace(Boolean var1);

        public Builder clientToken(String var1);

        public Builder permissionVersion(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

