/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ram.RamAsyncClient;
import software.amazon.awssdk.services.ram.internal.UserAgentUtils;
import software.amazon.awssdk.services.ram.model.ListResourceSharePermissionsRequest;
import software.amazon.awssdk.services.ram.model.ListResourceSharePermissionsResponse;

public class ListResourceSharePermissionsPublisher
implements SdkPublisher<ListResourceSharePermissionsResponse> {
    private final RamAsyncClient client;
    private final ListResourceSharePermissionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListResourceSharePermissionsPublisher(RamAsyncClient client, ListResourceSharePermissionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListResourceSharePermissionsPublisher(RamAsyncClient client, ListResourceSharePermissionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListResourceSharePermissionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListResourceSharePermissionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListResourceSharePermissionsResponseFetcher
    implements AsyncPageFetcher<ListResourceSharePermissionsResponse> {
        private ListResourceSharePermissionsResponseFetcher() {
        }

        public boolean hasNextPage(ListResourceSharePermissionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListResourceSharePermissionsResponse> nextPage(ListResourceSharePermissionsResponse previousPage) {
            if (previousPage == null) {
                return ListResourceSharePermissionsPublisher.this.client.listResourceSharePermissions(ListResourceSharePermissionsPublisher.this.firstRequest);
            }
            return ListResourceSharePermissionsPublisher.this.client.listResourceSharePermissions((ListResourceSharePermissionsRequest)((Object)ListResourceSharePermissionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

