/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ram.model.RamResponse;
import software.amazon.awssdk.services.ram.model.ResourceShare;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateResourceShareResponse
extends RamResponse
implements ToCopyableBuilder<Builder, UpdateResourceShareResponse> {
    private static final SdkField<ResourceShare> RESOURCE_SHARE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resourceShare").getter(UpdateResourceShareResponse.getter(UpdateResourceShareResponse::resourceShare)).setter(UpdateResourceShareResponse.setter(Builder::resourceShare)).constructor(ResourceShare::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceShare").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateResourceShareResponse.getter(UpdateResourceShareResponse::clientToken)).setter(UpdateResourceShareResponse.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_SHARE_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateResourceShareResponse.memberNameToFieldInitializer();
    private final ResourceShare resourceShare;
    private final String clientToken;

    private UpdateResourceShareResponse(BuilderImpl builder) {
        super(builder);
        this.resourceShare = builder.resourceShare;
        this.clientToken = builder.clientToken;
    }

    public final ResourceShare resourceShare() {
        return this.resourceShare;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceShare());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateResourceShareResponse)) {
            return false;
        }
        UpdateResourceShareResponse other = (UpdateResourceShareResponse)((Object)obj);
        return Objects.equals(this.resourceShare(), other.resourceShare()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateResourceShareResponse").add("ResourceShare", (Object)this.resourceShare()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceShare": {
                return Optional.ofNullable(clazz.cast(this.resourceShare()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("resourceShare", RESOURCE_SHARE_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateResourceShareResponse, T> g) {
        return obj -> g.apply((UpdateResourceShareResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RamResponse.BuilderImpl
    implements Builder {
        private ResourceShare resourceShare;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateResourceShareResponse model) {
            super(model);
            this.resourceShare(model.resourceShare);
            this.clientToken(model.clientToken);
        }

        public final ResourceShare.Builder getResourceShare() {
            return this.resourceShare != null ? this.resourceShare.toBuilder() : null;
        }

        public final void setResourceShare(ResourceShare.BuilderImpl resourceShare) {
            this.resourceShare = resourceShare != null ? resourceShare.build() : null;
        }

        @Override
        public final Builder resourceShare(ResourceShare resourceShare) {
            this.resourceShare = resourceShare;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public UpdateResourceShareResponse build() {
            return new UpdateResourceShareResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateResourceShareResponse> {
        public Builder resourceShare(ResourceShare var1);

        default public Builder resourceShare(Consumer<ResourceShare.Builder> resourceShare) {
            return this.resourceShare((ResourceShare)((ResourceShare.Builder)ResourceShare.builder().applyMutation(resourceShare)).build());
        }

        public Builder clientToken(String var1);
    }
}

