/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ram.model.RamResponse;
import software.amazon.awssdk.services.ram.model.ResourceShareAssociation;
import software.amazon.awssdk.services.ram.model.ResourceShareAssociationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DisassociateResourceShareResponse
extends RamResponse
implements ToCopyableBuilder<Builder, DisassociateResourceShareResponse> {
    private static final SdkField<List<ResourceShareAssociation>> RESOURCE_SHARE_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resourceShareAssociations").getter(DisassociateResourceShareResponse.getter(DisassociateResourceShareResponse::resourceShareAssociations)).setter(DisassociateResourceShareResponse.setter(Builder::resourceShareAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceShareAssociations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceShareAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(DisassociateResourceShareResponse.getter(DisassociateResourceShareResponse::clientToken)).setter(DisassociateResourceShareResponse.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_SHARE_ASSOCIATIONS_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("resourceShareAssociations", RESOURCE_SHARE_ASSOCIATIONS_FIELD);
            this.put("clientToken", CLIENT_TOKEN_FIELD);
        }
    });
    private final List<ResourceShareAssociation> resourceShareAssociations;
    private final String clientToken;

    private DisassociateResourceShareResponse(BuilderImpl builder) {
        super(builder);
        this.resourceShareAssociations = builder.resourceShareAssociations;
        this.clientToken = builder.clientToken;
    }

    public final boolean hasResourceShareAssociations() {
        return this.resourceShareAssociations != null && !(this.resourceShareAssociations instanceof SdkAutoConstructList);
    }

    public final List<ResourceShareAssociation> resourceShareAssociations() {
        return this.resourceShareAssociations;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceShareAssociations() ? this.resourceShareAssociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateResourceShareResponse)) {
            return false;
        }
        DisassociateResourceShareResponse other = (DisassociateResourceShareResponse)((Object)obj);
        return this.hasResourceShareAssociations() == other.hasResourceShareAssociations() && Objects.equals(this.resourceShareAssociations(), other.resourceShareAssociations()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"DisassociateResourceShareResponse").add("ResourceShareAssociations", this.hasResourceShareAssociations() ? this.resourceShareAssociations() : null).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceShareAssociations": {
                return Optional.ofNullable(clazz.cast(this.resourceShareAssociations()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DisassociateResourceShareResponse, T> g) {
        return obj -> g.apply((DisassociateResourceShareResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RamResponse.BuilderImpl
    implements Builder {
        private List<ResourceShareAssociation> resourceShareAssociations = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateResourceShareResponse model) {
            super(model);
            this.resourceShareAssociations(model.resourceShareAssociations);
            this.clientToken(model.clientToken);
        }

        public final List<ResourceShareAssociation.Builder> getResourceShareAssociations() {
            List<ResourceShareAssociation.Builder> result = ResourceShareAssociationListCopier.copyToBuilder(this.resourceShareAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceShareAssociations(Collection<ResourceShareAssociation.BuilderImpl> resourceShareAssociations) {
            this.resourceShareAssociations = ResourceShareAssociationListCopier.copyFromBuilder(resourceShareAssociations);
        }

        @Override
        public final Builder resourceShareAssociations(Collection<ResourceShareAssociation> resourceShareAssociations) {
            this.resourceShareAssociations = ResourceShareAssociationListCopier.copy(resourceShareAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceShareAssociations(ResourceShareAssociation ... resourceShareAssociations) {
            this.resourceShareAssociations(Arrays.asList(resourceShareAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceShareAssociations(Consumer<ResourceShareAssociation.Builder> ... resourceShareAssociations) {
            this.resourceShareAssociations(Stream.of(resourceShareAssociations).map(c -> (ResourceShareAssociation)((ResourceShareAssociation.Builder)ResourceShareAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public DisassociateResourceShareResponse build() {
            return new DisassociateResourceShareResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DisassociateResourceShareResponse> {
        public Builder resourceShareAssociations(Collection<ResourceShareAssociation> var1);

        public Builder resourceShareAssociations(ResourceShareAssociation ... var1);

        public Builder resourceShareAssociations(Consumer<ResourceShareAssociation.Builder> ... var1);

        public Builder clientToken(String var1);
    }
}

