/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ram.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateResourceSharePermissionRequest extends RamRequest implements
        ToCopyableBuilder<AssociateResourceSharePermissionRequest.Builder, AssociateResourceSharePermissionRequest> {
    private static final SdkField<String> RESOURCE_SHARE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AssociateResourceSharePermissionRequest::resourceShareArn)).setter(setter(Builder::resourceShareArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceShareArn").build()).build();

    private static final SdkField<String> PERMISSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AssociateResourceSharePermissionRequest::permissionArn)).setter(setter(Builder::permissionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissionArn").build()).build();

    private static final SdkField<Boolean> REPLACE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(AssociateResourceSharePermissionRequest::replace)).setter(setter(Builder::replace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replace").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AssociateResourceSharePermissionRequest::clientToken)).setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_SHARE_ARN_FIELD,
            PERMISSION_ARN_FIELD, REPLACE_FIELD, CLIENT_TOKEN_FIELD));

    private final String resourceShareArn;

    private final String permissionArn;

    private final Boolean replace;

    private final String clientToken;

    private AssociateResourceSharePermissionRequest(BuilderImpl builder) {
        super(builder);
        this.resourceShareArn = builder.resourceShareArn;
        this.permissionArn = builder.permissionArn;
        this.replace = builder.replace;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource share.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the resource share.
     */
    public String resourceShareArn() {
        return resourceShareArn;
    }

    /**
     * <p>
     * The ARN of the AWS RAM permission to associate with the resource share.
     * </p>
     * 
     * @return The ARN of the AWS RAM permission to associate with the resource share.
     */
    public String permissionArn() {
        return permissionArn;
    }

    /**
     * <p>
     * Indicates whether the permission should replace the permissions that are currently associated with the resource
     * share. Use <code>true</code> to replace the current permissions. Use <code>false</code> to add the permission to
     * the current permission.
     * </p>
     * 
     * @return Indicates whether the permission should replace the permissions that are currently associated with the
     *         resource share. Use <code>true</code> to replace the current permissions. Use <code>false</code> to add
     *         the permission to the current permission.
     */
    public Boolean replace() {
        return replace;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceShareArn());
        hashCode = 31 * hashCode + Objects.hashCode(permissionArn());
        hashCode = 31 * hashCode + Objects.hashCode(replace());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateResourceSharePermissionRequest)) {
            return false;
        }
        AssociateResourceSharePermissionRequest other = (AssociateResourceSharePermissionRequest) obj;
        return Objects.equals(resourceShareArn(), other.resourceShareArn())
                && Objects.equals(permissionArn(), other.permissionArn()) && Objects.equals(replace(), other.replace())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AssociateResourceSharePermissionRequest").add("ResourceShareArn", resourceShareArn())
                .add("PermissionArn", permissionArn()).add("Replace", replace()).add("ClientToken", clientToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceShareArn":
            return Optional.ofNullable(clazz.cast(resourceShareArn()));
        case "permissionArn":
            return Optional.ofNullable(clazz.cast(permissionArn()));
        case "replace":
            return Optional.ofNullable(clazz.cast(replace()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateResourceSharePermissionRequest, T> g) {
        return obj -> g.apply((AssociateResourceSharePermissionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RamRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociateResourceSharePermissionRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the resource share.
         * </p>
         * 
         * @param resourceShareArn
         *        The Amazon Resource Name (ARN) of the resource share.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceShareArn(String resourceShareArn);

        /**
         * <p>
         * The ARN of the AWS RAM permission to associate with the resource share.
         * </p>
         * 
         * @param permissionArn
         *        The ARN of the AWS RAM permission to associate with the resource share.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionArn(String permissionArn);

        /**
         * <p>
         * Indicates whether the permission should replace the permissions that are currently associated with the
         * resource share. Use <code>true</code> to replace the current permissions. Use <code>false</code> to add the
         * permission to the current permission.
         * </p>
         * 
         * @param replace
         *        Indicates whether the permission should replace the permissions that are currently associated with the
         *        resource share. Use <code>true</code> to replace the current permissions. Use <code>false</code> to
         *        add the permission to the current permission.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replace(Boolean replace);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RamRequest.BuilderImpl implements Builder {
        private String resourceShareArn;

        private String permissionArn;

        private Boolean replace;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateResourceSharePermissionRequest model) {
            super(model);
            resourceShareArn(model.resourceShareArn);
            permissionArn(model.permissionArn);
            replace(model.replace);
            clientToken(model.clientToken);
        }

        public final String getResourceShareArn() {
            return resourceShareArn;
        }

        @Override
        public final Builder resourceShareArn(String resourceShareArn) {
            this.resourceShareArn = resourceShareArn;
            return this;
        }

        public final void setResourceShareArn(String resourceShareArn) {
            this.resourceShareArn = resourceShareArn;
        }

        public final String getPermissionArn() {
            return permissionArn;
        }

        @Override
        public final Builder permissionArn(String permissionArn) {
            this.permissionArn = permissionArn;
            return this;
        }

        public final void setPermissionArn(String permissionArn) {
            this.permissionArn = permissionArn;
        }

        public final Boolean getReplace() {
            return replace;
        }

        @Override
        public final Builder replace(Boolean replace) {
            this.replace = replace;
            return this;
        }

        public final void setReplace(Boolean replace) {
            this.replace = replace;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateResourceSharePermissionRequest build() {
            return new AssociateResourceSharePermissionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
