/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ram.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateResourceShareResponse extends RamResponse implements
        ToCopyableBuilder<CreateResourceShareResponse.Builder, CreateResourceShareResponse> {
    private static final SdkField<ResourceShare> RESOURCE_SHARE_FIELD = SdkField
            .<ResourceShare> builder(MarshallingType.SDK_POJO).getter(getter(CreateResourceShareResponse::resourceShare))
            .setter(setter(Builder::resourceShare)).constructor(ResourceShare::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceShare").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateResourceShareResponse::clientToken)).setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_SHARE_FIELD,
            CLIENT_TOKEN_FIELD));

    private final ResourceShare resourceShare;

    private final String clientToken;

    private CreateResourceShareResponse(BuilderImpl builder) {
        super(builder);
        this.resourceShare = builder.resourceShare;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * Information about the resource share.
     * </p>
     * 
     * @return Information about the resource share.
     */
    public ResourceShare resourceShare() {
        return resourceShare;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceShare());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateResourceShareResponse)) {
            return false;
        }
        CreateResourceShareResponse other = (CreateResourceShareResponse) obj;
        return Objects.equals(resourceShare(), other.resourceShare()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateResourceShareResponse").add("ResourceShare", resourceShare())
                .add("ClientToken", clientToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceShare":
            return Optional.ofNullable(clazz.cast(resourceShare()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateResourceShareResponse, T> g) {
        return obj -> g.apply((CreateResourceShareResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RamResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateResourceShareResponse> {
        /**
         * <p>
         * Information about the resource share.
         * </p>
         * 
         * @param resourceShare
         *        Information about the resource share.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceShare(ResourceShare resourceShare);

        /**
         * <p>
         * Information about the resource share.
         * </p>
         * This is a convenience that creates an instance of the {@link ResourceShare.Builder} avoiding the need to
         * create one manually via {@link ResourceShare#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceShare.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceShare(ResourceShare)}.
         * 
         * @param resourceShare
         *        a consumer that will call methods on {@link ResourceShare.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceShare(ResourceShare)
         */
        default Builder resourceShare(Consumer<ResourceShare.Builder> resourceShare) {
            return resourceShare(ResourceShare.builder().applyMutation(resourceShare).build());
        }

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);
    }

    static final class BuilderImpl extends RamResponse.BuilderImpl implements Builder {
        private ResourceShare resourceShare;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateResourceShareResponse model) {
            super(model);
            resourceShare(model.resourceShare);
            clientToken(model.clientToken);
        }

        public final ResourceShare.Builder getResourceShare() {
            return resourceShare != null ? resourceShare.toBuilder() : null;
        }

        @Override
        public final Builder resourceShare(ResourceShare resourceShare) {
            this.resourceShare = resourceShare;
            return this;
        }

        public final void setResourceShare(ResourceShare.BuilderImpl resourceShare) {
            this.resourceShare = resourceShare != null ? resourceShare.build() : null;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public CreateResourceShareResponse build() {
            return new CreateResourceShareResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
