/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ram.model.RamResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteResourceShareResponse
extends RamResponse
implements ToCopyableBuilder<Builder, DeleteResourceShareResponse> {
    private static final SdkField<Boolean> RETURN_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(DeleteResourceShareResponse.getter(DeleteResourceShareResponse::returnValue)).setter(DeleteResourceShareResponse.setter(Builder::returnValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("returnValue").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteResourceShareResponse.getter(DeleteResourceShareResponse::clientToken)).setter(DeleteResourceShareResponse.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RETURN_VALUE_FIELD, CLIENT_TOKEN_FIELD));
    private final Boolean returnValue;
    private final String clientToken;

    private DeleteResourceShareResponse(BuilderImpl builder) {
        super(builder);
        this.returnValue = builder.returnValue;
        this.clientToken = builder.clientToken;
    }

    public Boolean returnValue() {
        return this.returnValue;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.returnValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteResourceShareResponse)) {
            return false;
        }
        DeleteResourceShareResponse other = (DeleteResourceShareResponse)((Object)obj);
        return Objects.equals(this.returnValue(), other.returnValue()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public String toString() {
        return ToString.builder((String)"DeleteResourceShareResponse").add("ReturnValue", (Object)this.returnValue()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "returnValue": {
                return Optional.ofNullable(clazz.cast(this.returnValue()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteResourceShareResponse, T> g) {
        return obj -> g.apply((DeleteResourceShareResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RamResponse.BuilderImpl
    implements Builder {
        private Boolean returnValue;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteResourceShareResponse model) {
            super(model);
            this.returnValue(model.returnValue);
            this.clientToken(model.clientToken);
        }

        public final Boolean getReturnValue() {
            return this.returnValue;
        }

        @Override
        public final Builder returnValue(Boolean returnValue) {
            this.returnValue = returnValue;
            return this;
        }

        public final void setReturnValue(Boolean returnValue) {
            this.returnValue = returnValue;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public DeleteResourceShareResponse build() {
            return new DeleteResourceShareResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteResourceShareResponse> {
        public Builder returnValue(Boolean var1);

        public Builder clientToken(String var1);
    }
}

