/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDashboardEmbedUrlResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, GetDashboardEmbedUrlResponse> {
    private static final SdkField<String> EMBED_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetDashboardEmbedUrlResponse.getter(GetDashboardEmbedUrlResponse::embedUrl)).setter(GetDashboardEmbedUrlResponse.setter(Builder::embedUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmbedUrl").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(GetDashboardEmbedUrlResponse.getter(GetDashboardEmbedUrlResponse::status)).setter(GetDashboardEmbedUrlResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetDashboardEmbedUrlResponse.getter(GetDashboardEmbedUrlResponse::requestId)).setter(GetDashboardEmbedUrlResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EMBED_URL_FIELD, STATUS_FIELD, REQUEST_ID_FIELD));
    private final String embedUrl;
    private final Integer status;
    private final String requestId;

    private GetDashboardEmbedUrlResponse(BuilderImpl builder) {
        super(builder);
        this.embedUrl = builder.embedUrl;
        this.status = builder.status;
        this.requestId = builder.requestId;
    }

    public String embedUrl() {
        return this.embedUrl;
    }

    public Integer status() {
        return this.status;
    }

    public String requestId() {
        return this.requestId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.embedUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDashboardEmbedUrlResponse)) {
            return false;
        }
        GetDashboardEmbedUrlResponse other = (GetDashboardEmbedUrlResponse)((Object)obj);
        return Objects.equals(this.embedUrl(), other.embedUrl()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.requestId(), other.requestId());
    }

    public String toString() {
        return ToString.builder((String)"GetDashboardEmbedUrlResponse").add("EmbedUrl", (Object)(this.embedUrl() == null ? null : "*** Sensitive Data Redacted ***")).add("Status", (Object)this.status()).add("RequestId", (Object)this.requestId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EmbedUrl": {
                return Optional.ofNullable(clazz.cast(this.embedUrl()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDashboardEmbedUrlResponse, T> g) {
        return obj -> g.apply((GetDashboardEmbedUrlResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private String embedUrl;
        private Integer status;
        private String requestId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDashboardEmbedUrlResponse model) {
            super(model);
            this.embedUrl(model.embedUrl);
            this.status(model.status);
            this.requestId(model.requestId);
        }

        public final String getEmbedUrl() {
            return this.embedUrl;
        }

        @Override
        public final Builder embedUrl(String embedUrl) {
            this.embedUrl = embedUrl;
            return this;
        }

        public final void setEmbedUrl(String embedUrl) {
            this.embedUrl = embedUrl;
        }

        public final Integer getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public GetDashboardEmbedUrlResponse build() {
            return new GetDashboardEmbedUrlResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDashboardEmbedUrlResponse> {
        public Builder embedUrl(String var1);

        public Builder status(Integer var1);

        public Builder requestId(String var1);
    }
}

