/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightAsyncClient;
import software.amazon.awssdk.services.quicksight.internal.UserAgentUtils;
import software.amazon.awssdk.services.quicksight.model.Group;
import software.amazon.awssdk.services.quicksight.model.SearchGroupsRequest;
import software.amazon.awssdk.services.quicksight.model.SearchGroupsResponse;

public class SearchGroupsPublisher
implements SdkPublisher<SearchGroupsResponse> {
    private final QuickSightAsyncClient client;
    private final SearchGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchGroupsPublisher(QuickSightAsyncClient client, SearchGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchGroupsPublisher(QuickSightAsyncClient client, SearchGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Group> groupList() {
        return this.flatMapIterable(response -> response.groupList());
    }

    private class SearchGroupsResponseFetcher
    implements AsyncPageFetcher<SearchGroupsResponse> {
        private SearchGroupsResponseFetcher() {
        }

        public boolean hasNextPage(SearchGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchGroupsResponse> nextPage(SearchGroupsResponse previousPage) {
            if (previousPage == null) {
                return SearchGroupsPublisher.this.client.searchGroups(SearchGroupsPublisher.this.firstRequest);
            }
            return SearchGroupsPublisher.this.client.searchGroups((SearchGroupsRequest)((Object)SearchGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

