/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightAsyncClient;
import software.amazon.awssdk.services.quicksight.internal.UserAgentUtils;
import software.amazon.awssdk.services.quicksight.model.FolderSummary;
import software.amazon.awssdk.services.quicksight.model.SearchFoldersRequest;
import software.amazon.awssdk.services.quicksight.model.SearchFoldersResponse;

public class SearchFoldersPublisher
implements SdkPublisher<SearchFoldersResponse> {
    private final QuickSightAsyncClient client;
    private final SearchFoldersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchFoldersPublisher(QuickSightAsyncClient client, SearchFoldersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchFoldersPublisher(QuickSightAsyncClient client, SearchFoldersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchFoldersResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchFoldersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<FolderSummary> folderSummaryList() {
        return this.flatMapIterable(response -> response.folderSummaryList());
    }

    private class SearchFoldersResponseFetcher
    implements AsyncPageFetcher<SearchFoldersResponse> {
        private SearchFoldersResponseFetcher() {
        }

        public boolean hasNextPage(SearchFoldersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchFoldersResponse> nextPage(SearchFoldersResponse previousPage) {
            if (previousPage == null) {
                return SearchFoldersPublisher.this.client.searchFolders(SearchFoldersPublisher.this.firstRequest);
            }
            return SearchFoldersPublisher.this.client.searchFolders((SearchFoldersRequest)((Object)SearchFoldersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

