/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightAsyncClient;
import software.amazon.awssdk.services.quicksight.internal.UserAgentUtils;
import software.amazon.awssdk.services.quicksight.model.FlowSummary;
import software.amazon.awssdk.services.quicksight.model.SearchFlowsRequest;
import software.amazon.awssdk.services.quicksight.model.SearchFlowsResponse;

public class SearchFlowsPublisher
implements SdkPublisher<SearchFlowsResponse> {
    private final QuickSightAsyncClient client;
    private final SearchFlowsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchFlowsPublisher(QuickSightAsyncClient client, SearchFlowsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchFlowsPublisher(QuickSightAsyncClient client, SearchFlowsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchFlowsResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchFlowsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<FlowSummary> flowSummaryList() {
        return this.flatMapIterable(response -> response.flowSummaryList());
    }

    private class SearchFlowsResponseFetcher
    implements AsyncPageFetcher<SearchFlowsResponse> {
        private SearchFlowsResponseFetcher() {
        }

        public boolean hasNextPage(SearchFlowsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchFlowsResponse> nextPage(SearchFlowsResponse previousPage) {
            if (previousPage == null) {
                return SearchFlowsPublisher.this.client.searchFlows(SearchFlowsPublisher.this.firstRequest);
            }
            return SearchFlowsPublisher.this.client.searchFlows((SearchFlowsRequest)((Object)SearchFlowsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

