/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightAsyncClient;
import software.amazon.awssdk.services.quicksight.internal.UserAgentUtils;
import software.amazon.awssdk.services.quicksight.model.DataSetSummary;
import software.amazon.awssdk.services.quicksight.model.SearchDataSetsRequest;
import software.amazon.awssdk.services.quicksight.model.SearchDataSetsResponse;

public class SearchDataSetsPublisher
implements SdkPublisher<SearchDataSetsResponse> {
    private final QuickSightAsyncClient client;
    private final SearchDataSetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchDataSetsPublisher(QuickSightAsyncClient client, SearchDataSetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchDataSetsPublisher(QuickSightAsyncClient client, SearchDataSetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchDataSetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchDataSetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DataSetSummary> dataSetSummaries() {
        return this.flatMapIterable(response -> response.dataSetSummaries());
    }

    private class SearchDataSetsResponseFetcher
    implements AsyncPageFetcher<SearchDataSetsResponse> {
        private SearchDataSetsResponseFetcher() {
        }

        public boolean hasNextPage(SearchDataSetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchDataSetsResponse> nextPage(SearchDataSetsResponse previousPage) {
            if (previousPage == null) {
                return SearchDataSetsPublisher.this.client.searchDataSets(SearchDataSetsPublisher.this.firstRequest);
            }
            return SearchDataSetsPublisher.this.client.searchDataSets((SearchDataSetsRequest)((Object)SearchDataSetsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

