/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightAsyncClient;
import software.amazon.awssdk.services.quicksight.internal.UserAgentUtils;
import software.amazon.awssdk.services.quicksight.model.ListTemplateVersionsRequest;
import software.amazon.awssdk.services.quicksight.model.ListTemplateVersionsResponse;
import software.amazon.awssdk.services.quicksight.model.TemplateVersionSummary;

public class ListTemplateVersionsPublisher
implements SdkPublisher<ListTemplateVersionsResponse> {
    private final QuickSightAsyncClient client;
    private final ListTemplateVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTemplateVersionsPublisher(QuickSightAsyncClient client, ListTemplateVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTemplateVersionsPublisher(QuickSightAsyncClient client, ListTemplateVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTemplateVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTemplateVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TemplateVersionSummary> templateVersionSummaryList() {
        return this.flatMapIterable(response -> response.templateVersionSummaryList());
    }

    private class ListTemplateVersionsResponseFetcher
    implements AsyncPageFetcher<ListTemplateVersionsResponse> {
        private ListTemplateVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListTemplateVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTemplateVersionsResponse> nextPage(ListTemplateVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListTemplateVersionsPublisher.this.client.listTemplateVersions(ListTemplateVersionsPublisher.this.firstRequest);
            }
            return ListTemplateVersionsPublisher.this.client.listTemplateVersions((ListTemplateVersionsRequest)((Object)ListTemplateVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

