/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightAsyncClient;
import software.amazon.awssdk.services.quicksight.internal.UserAgentUtils;
import software.amazon.awssdk.services.quicksight.model.ListTemplateAliasesRequest;
import software.amazon.awssdk.services.quicksight.model.ListTemplateAliasesResponse;
import software.amazon.awssdk.services.quicksight.model.TemplateAlias;

public class ListTemplateAliasesPublisher
implements SdkPublisher<ListTemplateAliasesResponse> {
    private final QuickSightAsyncClient client;
    private final ListTemplateAliasesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTemplateAliasesPublisher(QuickSightAsyncClient client, ListTemplateAliasesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTemplateAliasesPublisher(QuickSightAsyncClient client, ListTemplateAliasesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTemplateAliasesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTemplateAliasesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TemplateAlias> templateAliasList() {
        return this.flatMapIterable(response -> response.templateAliasList());
    }

    private class ListTemplateAliasesResponseFetcher
    implements AsyncPageFetcher<ListTemplateAliasesResponse> {
        private ListTemplateAliasesResponseFetcher() {
        }

        public boolean hasNextPage(ListTemplateAliasesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTemplateAliasesResponse> nextPage(ListTemplateAliasesResponse previousPage) {
            if (previousPage == null) {
                return ListTemplateAliasesPublisher.this.client.listTemplateAliases(ListTemplateAliasesPublisher.this.firstRequest);
            }
            return ListTemplateAliasesPublisher.this.client.listTemplateAliases((ListTemplateAliasesRequest)((Object)ListTemplateAliasesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

