/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightAsyncClient;
import software.amazon.awssdk.services.quicksight.internal.UserAgentUtils;
import software.amazon.awssdk.services.quicksight.model.Ingestion;
import software.amazon.awssdk.services.quicksight.model.ListIngestionsRequest;
import software.amazon.awssdk.services.quicksight.model.ListIngestionsResponse;

public class ListIngestionsPublisher
implements SdkPublisher<ListIngestionsResponse> {
    private final QuickSightAsyncClient client;
    private final ListIngestionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListIngestionsPublisher(QuickSightAsyncClient client, ListIngestionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListIngestionsPublisher(QuickSightAsyncClient client, ListIngestionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListIngestionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListIngestionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Ingestion> ingestions() {
        return this.flatMapIterable(response -> response.ingestions());
    }

    private class ListIngestionsResponseFetcher
    implements AsyncPageFetcher<ListIngestionsResponse> {
        private ListIngestionsResponseFetcher() {
        }

        public boolean hasNextPage(ListIngestionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListIngestionsResponse> nextPage(ListIngestionsResponse previousPage) {
            if (previousPage == null) {
                return ListIngestionsPublisher.this.client.listIngestions(ListIngestionsPublisher.this.firstRequest);
            }
            return ListIngestionsPublisher.this.client.listIngestions((ListIngestionsRequest)((Object)ListIngestionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

