/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightAsyncClient;
import software.amazon.awssdk.services.quicksight.internal.UserAgentUtils;
import software.amazon.awssdk.services.quicksight.model.ActiveIAMPolicyAssignment;
import software.amazon.awssdk.services.quicksight.model.ListIamPolicyAssignmentsForUserRequest;
import software.amazon.awssdk.services.quicksight.model.ListIamPolicyAssignmentsForUserResponse;

public class ListIAMPolicyAssignmentsForUserPublisher
implements SdkPublisher<ListIamPolicyAssignmentsForUserResponse> {
    private final QuickSightAsyncClient client;
    private final ListIamPolicyAssignmentsForUserRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListIAMPolicyAssignmentsForUserPublisher(QuickSightAsyncClient client, ListIamPolicyAssignmentsForUserRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListIAMPolicyAssignmentsForUserPublisher(QuickSightAsyncClient client, ListIamPolicyAssignmentsForUserRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListIamPolicyAssignmentsForUserResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListIamPolicyAssignmentsForUserResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ActiveIAMPolicyAssignment> activeAssignments() {
        return this.flatMapIterable(response -> response.activeAssignments());
    }

    private class ListIamPolicyAssignmentsForUserResponseFetcher
    implements AsyncPageFetcher<ListIamPolicyAssignmentsForUserResponse> {
        private ListIamPolicyAssignmentsForUserResponseFetcher() {
        }

        public boolean hasNextPage(ListIamPolicyAssignmentsForUserResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListIamPolicyAssignmentsForUserResponse> nextPage(ListIamPolicyAssignmentsForUserResponse previousPage) {
            if (previousPage == null) {
                return ListIAMPolicyAssignmentsForUserPublisher.this.client.listIAMPolicyAssignmentsForUser(ListIAMPolicyAssignmentsForUserPublisher.this.firstRequest);
            }
            return ListIAMPolicyAssignmentsForUserPublisher.this.client.listIAMPolicyAssignmentsForUser((ListIamPolicyAssignmentsForUserRequest)((Object)ListIAMPolicyAssignmentsForUserPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

