/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightAsyncClient;
import software.amazon.awssdk.services.quicksight.internal.UserAgentUtils;
import software.amazon.awssdk.services.quicksight.model.ListFoldersForResourceRequest;
import software.amazon.awssdk.services.quicksight.model.ListFoldersForResourceResponse;

public class ListFoldersForResourcePublisher
implements SdkPublisher<ListFoldersForResourceResponse> {
    private final QuickSightAsyncClient client;
    private final ListFoldersForResourceRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFoldersForResourcePublisher(QuickSightAsyncClient client, ListFoldersForResourceRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFoldersForResourcePublisher(QuickSightAsyncClient client, ListFoldersForResourceRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFoldersForResourceResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFoldersForResourceResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> folders() {
        return this.flatMapIterable(response -> response.folders());
    }

    private class ListFoldersForResourceResponseFetcher
    implements AsyncPageFetcher<ListFoldersForResourceResponse> {
        private ListFoldersForResourceResponseFetcher() {
        }

        public boolean hasNextPage(ListFoldersForResourceResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListFoldersForResourceResponse> nextPage(ListFoldersForResourceResponse previousPage) {
            if (previousPage == null) {
                return ListFoldersForResourcePublisher.this.client.listFoldersForResource(ListFoldersForResourcePublisher.this.firstRequest);
            }
            return ListFoldersForResourcePublisher.this.client.listFoldersForResource((ListFoldersForResourceRequest)((Object)ListFoldersForResourcePublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

