/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightAsyncClient;
import software.amazon.awssdk.services.quicksight.internal.UserAgentUtils;
import software.amazon.awssdk.services.quicksight.model.ListFolderMembersRequest;
import software.amazon.awssdk.services.quicksight.model.ListFolderMembersResponse;
import software.amazon.awssdk.services.quicksight.model.MemberIdArnPair;

public class ListFolderMembersPublisher
implements SdkPublisher<ListFolderMembersResponse> {
    private final QuickSightAsyncClient client;
    private final ListFolderMembersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFolderMembersPublisher(QuickSightAsyncClient client, ListFolderMembersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFolderMembersPublisher(QuickSightAsyncClient client, ListFolderMembersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFolderMembersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFolderMembersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MemberIdArnPair> folderMemberList() {
        return this.flatMapIterable(response -> response.folderMemberList());
    }

    private class ListFolderMembersResponseFetcher
    implements AsyncPageFetcher<ListFolderMembersResponse> {
        private ListFolderMembersResponseFetcher() {
        }

        public boolean hasNextPage(ListFolderMembersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListFolderMembersResponse> nextPage(ListFolderMembersResponse previousPage) {
            if (previousPage == null) {
                return ListFolderMembersPublisher.this.client.listFolderMembers(ListFolderMembersPublisher.this.firstRequest);
            }
            return ListFolderMembersPublisher.this.client.listFolderMembers((ListFolderMembersRequest)((Object)ListFolderMembersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

