/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightAsyncClient;
import software.amazon.awssdk.services.quicksight.internal.UserAgentUtils;
import software.amazon.awssdk.services.quicksight.model.BrandSummary;
import software.amazon.awssdk.services.quicksight.model.ListBrandsRequest;
import software.amazon.awssdk.services.quicksight.model.ListBrandsResponse;

public class ListBrandsPublisher
implements SdkPublisher<ListBrandsResponse> {
    private final QuickSightAsyncClient client;
    private final ListBrandsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListBrandsPublisher(QuickSightAsyncClient client, ListBrandsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListBrandsPublisher(QuickSightAsyncClient client, ListBrandsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListBrandsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListBrandsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<BrandSummary> brands() {
        return this.flatMapIterable(response -> response.brands());
    }

    private class ListBrandsResponseFetcher
    implements AsyncPageFetcher<ListBrandsResponse> {
        private ListBrandsResponseFetcher() {
        }

        public boolean hasNextPage(ListBrandsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListBrandsResponse> nextPage(ListBrandsResponse previousPage) {
            if (previousPage == null) {
                return ListBrandsPublisher.this.client.listBrands(ListBrandsPublisher.this.firstRequest);
            }
            return ListBrandsPublisher.this.client.listBrands((ListBrandsRequest)((Object)ListBrandsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

