/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightAsyncClient;
import software.amazon.awssdk.services.quicksight.internal.UserAgentUtils;
import software.amazon.awssdk.services.quicksight.model.AnalysisSummary;
import software.amazon.awssdk.services.quicksight.model.ListAnalysesRequest;
import software.amazon.awssdk.services.quicksight.model.ListAnalysesResponse;

public class ListAnalysesPublisher
implements SdkPublisher<ListAnalysesResponse> {
    private final QuickSightAsyncClient client;
    private final ListAnalysesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAnalysesPublisher(QuickSightAsyncClient client, ListAnalysesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAnalysesPublisher(QuickSightAsyncClient client, ListAnalysesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAnalysesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAnalysesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AnalysisSummary> analysisSummaryList() {
        return this.flatMapIterable(response -> response.analysisSummaryList());
    }

    private class ListAnalysesResponseFetcher
    implements AsyncPageFetcher<ListAnalysesResponse> {
        private ListAnalysesResponseFetcher() {
        }

        public boolean hasNextPage(ListAnalysesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAnalysesResponse> nextPage(ListAnalysesResponse previousPage) {
            if (previousPage == null) {
                return ListAnalysesPublisher.this.client.listAnalyses(ListAnalysesPublisher.this.firstRequest);
            }
            return ListAnalysesPublisher.this.client.listAnalyses((ListAnalysesRequest)((Object)ListAnalysesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

